/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.json.jackson.datavalues;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.interfaces.ItemIdValue;
import org.wikidata.wdtk.datamodel.interfaces.ValueVisitor;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonTermedDocument;
import org.wikidata.wdtk.datamodel.json.jackson.datavalues.JacksonInnerEntityId;
import org.wikidata.wdtk.datamodel.json.jackson.datavalues.JacksonValue;

@JsonIgnoreProperties(ignoreUnknown=true)
public class JacksonValueItemId
extends JacksonValue
implements ItemIdValue {
    @JsonIgnore
    JacksonTermedDocument parentDocument;
    private JacksonInnerEntityId value;

    public JacksonValueItemId() {
        super("wikibase-entityid");
    }

    public JacksonInnerEntityId getValue() {
        return this.value;
    }

    public void setValue(JacksonInnerEntityId value) {
        this.value = value;
    }

    @Override
    @JsonIgnore
    public String getIri() {
        return this.getSiteIri().concat(this.getId());
    }

    @Override
    @JsonIgnore
    public String getId() {
        return this.value.getStringId();
    }

    @Override
    @JsonIgnore
    public String getSiteIri() {
        if (this.parentDocument != null && this.parentDocument.getSiteIri() != null) {
            return this.parentDocument.getSiteIri();
        }
        throw new RuntimeException("Cannot access the site IRI id of an insufficiently initialised Jackson value.");
    }

    @Override
    @JsonIgnore
    public String getEntityType() {
        return "http://www.wikidata.org/ontology#Item";
    }

    @JsonIgnore
    public void setParentDocument(JacksonTermedDocument parentDocument) {
        this.parentDocument = parentDocument;
    }

    @Override
    public <T> T accept(ValueVisitor<T> valueVisitor) {
        return valueVisitor.visit(this);
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsEntityIdValue(this, obj);
    }

    public String toString() {
        return ToString.toString(this);
    }
}

