/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.json.jackson.datavalues;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public class JacksonInnerEntityId {
    public static final String JSON_ENTITY_TYPE_ITEM = "item";
    @JsonProperty(value="entity-type")
    private String entityType;
    @JsonProperty(value="numeric-id")
    private int numericId;

    public JacksonInnerEntityId() {
    }

    public JacksonInnerEntityId(String entityType, int numericId) throws IllegalArgumentException {
        this.setEntityType(entityType);
        this.numericId = numericId;
    }

    @JsonProperty(value="entity-type")
    public String getEntityType() {
        return this.entityType;
    }

    @JsonProperty(value="entity-type")
    public void setEntityType(String entityType) throws IllegalArgumentException {
        if (!JSON_ENTITY_TYPE_ITEM.equals(entityType)) {
            throw new IllegalArgumentException("Entities of type " + entityType + " are not supported in property values.");
        }
        this.entityType = entityType;
    }

    @JsonProperty(value="numeric-id")
    public int getNumericId() {
        return this.numericId;
    }

    @JsonProperty(value="numeric-id")
    public void setNumericId(int numericId) {
        this.numericId = numericId;
    }

    @JsonIgnore
    public String getStringId() {
        return "Q" + this.numericId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JacksonInnerEntityId)) {
            return false;
        }
        return this.numericId == ((JacksonInnerEntityId)o).numericId && this.entityType.equals(((JacksonInnerEntityId)o).entityType);
    }
}

