/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.json.jackson;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.interfaces.SnakVisitor;
import org.wikidata.wdtk.datamodel.interfaces.Value;
import org.wikidata.wdtk.datamodel.interfaces.ValueSnak;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonSnak;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonTermedDocument;
import org.wikidata.wdtk.datamodel.json.jackson.datavalues.JacksonValue;
import org.wikidata.wdtk.datamodel.json.jackson.datavalues.JacksonValueItemId;

public class JacksonValueSnak
extends JacksonSnak
implements ValueSnak {
    private JacksonValue datavalue;
    private String datatype;

    public JacksonValueSnak() {
        this.setSnakType("value");
    }

    @Override
    @JsonIgnore
    public Value getValue() {
        return this.datavalue;
    }

    public String getDatatype() {
        return this.datatype;
    }

    public void setDatatype(String datatype) {
        this.datatype = datatype;
    }

    public void setDatavalue(JacksonValue datavalue) {
        this.datavalue = datavalue;
    }

    public JacksonValue getDatavalue() {
        return this.datavalue;
    }

    @Override
    void setParentDocument(JacksonTermedDocument parentDocument) {
        super.setParentDocument(parentDocument);
        if (this.datavalue instanceof JacksonValueItemId) {
            ((JacksonValueItemId)this.datavalue).setParentDocument(parentDocument);
        }
    }

    @Override
    public <T> T accept(SnakVisitor<T> snakVisitor) {
        return snakVisitor.visit(this);
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsValueSnak(this, obj);
    }

    public String toString() {
        return ToString.toString(this);
    }
}

