/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.json.jackson;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.TermedDocument;
import org.wikidata.wdtk.datamodel.json.jackson.AliasesDeserializer;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonItemDocument;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonMonolingualTextValue;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonPropertyDocument;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=JacksonItemDocument.class, name="item"), @JsonSubTypes.Type(value=JacksonPropertyDocument.class, name="property")})
public abstract class JacksonTermedDocument
implements TermedDocument {
    public static final String JSON_TYPE_ITEM = "item";
    public static final String JSON_TYPE_PROPERTY = "property";
    @JsonDeserialize(using=AliasesDeserializer.class)
    protected Map<String, List<JacksonMonolingualTextValue>> aliases = new HashMap<String, List<JacksonMonolingualTextValue>>();
    protected Map<String, JacksonMonolingualTextValue> labels = new HashMap<String, JacksonMonolingualTextValue>();
    protected Map<String, JacksonMonolingualTextValue> descriptions = new HashMap<String, JacksonMonolingualTextValue>();
    protected String entityId = "";
    @JsonIgnore
    protected String siteIri = null;

    public void setAliases(Map<String, List<JacksonMonolingualTextValue>> aliases) {
        this.aliases = aliases;
    }

    @Override
    public Map<String, List<MonolingualTextValue>> getAliases() {
        HashMap<String, List<JacksonMonolingualTextValue>> returnMap = new HashMap<String, List<JacksonMonolingualTextValue>>();
        for (Map.Entry<String, List<JacksonMonolingualTextValue>> entry : this.aliases.entrySet()) {
            returnMap.put(entry.getKey(), Collections.unmodifiableList(entry.getValue()));
        }
        return Collections.unmodifiableMap(returnMap);
    }

    public void setDescriptions(Map<String, JacksonMonolingualTextValue> descriptions) {
        this.descriptions = descriptions;
    }

    @Override
    public Map<String, MonolingualTextValue> getDescriptions() {
        return Collections.unmodifiableMap(this.descriptions);
    }

    public void setLabels(Map<String, JacksonMonolingualTextValue> labels) {
        this.labels = labels;
    }

    @Override
    public Map<String, MonolingualTextValue> getLabels() {
        return Collections.unmodifiableMap(this.labels);
    }

    @JsonProperty(value="id")
    public void setJsonId(String id) {
        this.entityId = id;
    }

    @JsonProperty(value="id")
    public String getJsonId() {
        return this.entityId;
    }

    @JsonIgnore
    public void setSiteIri(String siteIri) {
        this.siteIri = siteIri;
    }

    @JsonIgnore
    public String getSiteIri() {
        return this.siteIri;
    }

    @JsonProperty(value="type")
    public abstract String getJsonType();
}

