/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.json.jackson;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.wikidata.wdtk.datamodel.helpers.Datamodel;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.Snak;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonNoValueSnak;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonSomeValueSnak;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonTermedDocument;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonValueSnak;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="snaktype")
@JsonSubTypes(value={@JsonSubTypes.Type(value=JacksonNoValueSnak.class, name="novalue"), @JsonSubTypes.Type(value=JacksonSomeValueSnak.class, name="somevalue"), @JsonSubTypes.Type(value=JacksonValueSnak.class, name="value")})
@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class JacksonSnak
implements Snak {
    public static final String JSON_SNAK_TYPE_VALUE = "value";
    public static final String JSON_SNAK_TYPE_SOMEVALUE = "somevalue";
    public static final String JSON_SNAK_TYPE_NOVALUE = "novalue";
    private String property;
    private String snaktype;
    @JsonIgnore
    JacksonTermedDocument parentDocument;

    protected JacksonSnak() {
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    @Override
    @JsonIgnore
    public PropertyIdValue getPropertyId() {
        if (this.parentDocument != null && this.parentDocument.getSiteIri() != null) {
            return Datamodel.makePropertyIdValue(this.property, this.parentDocument.getSiteIri());
        }
        throw new RuntimeException("Cannot access the property id of an insufficiently initialised Jackson snak.");
    }

    public String getSnaktype() {
        return this.snaktype;
    }

    public void setSnakType(String snacktype) {
        this.snaktype = snacktype;
    }

    @JsonIgnore
    void setParentDocument(JacksonTermedDocument parentDocument) {
        this.parentDocument = parentDocument;
    }
}

