/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.json.jackson;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.interfaces.Reference;
import org.wikidata.wdtk.datamodel.interfaces.Snak;
import org.wikidata.wdtk.datamodel.interfaces.SnakGroup;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonSnak;
import org.wikidata.wdtk.datamodel.json.jackson.SnakGroupFromJson;
import org.wikidata.wdtk.util.NestedIterator;

@JsonIgnoreProperties(ignoreUnknown=true)
public class JacksonReference
implements Reference {
    private List<SnakGroup> snakGroups = null;
    Map<String, List<JacksonSnak>> snaks;
    List<String> propertyOrder;

    @Override
    @JsonIgnore
    public List<SnakGroup> getSnakGroups() {
        if (this.snakGroups == null) {
            this.snakGroups = SnakGroupFromJson.makeSnakGroups(this.snaks, this.propertyOrder);
        }
        return this.snakGroups;
    }

    public void setSnaks(Map<String, List<JacksonSnak>> snaks) {
        this.snaks = snaks;
        this.snakGroups = null;
    }

    public Map<String, List<JacksonSnak>> getSnaks() {
        return this.snaks;
    }

    @JsonProperty(value="snaks-order")
    public void setPropertyOrder(List<String> propertyOrder) {
        this.propertyOrder = propertyOrder;
        this.snakGroups = null;
    }

    @JsonProperty(value="snaks-order")
    public List<String> getPropertyOrder() {
        return this.propertyOrder;
    }

    @Override
    public Iterator<Snak> getAllSnaks() {
        return new NestedIterator(this.getSnakGroups());
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsReference(this, obj);
    }

    public String toString() {
        return ToString.toString(this);
    }
}

