/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.json.jackson;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.wikidata.wdtk.datamodel.helpers.Datamodel;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.interfaces.DatatypeIdValue;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.PropertyDocument;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonDatatypeId;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonTermedDocument;

public class JacksonPropertyDocument
extends JacksonTermedDocument
implements PropertyDocument {
    private String datatype;

    @JsonProperty(value="datatype")
    public String getJsonDatatype() {
        return this.datatype;
    }

    @JsonProperty(value="datatype")
    public void setJsonDatatype(String datatype) {
        this.datatype = datatype;
    }

    @Override
    @JsonIgnore
    public PropertyIdValue getPropertyId() {
        if (this.siteIri == null) {
            return Datamodel.makeWikidataPropertyIdValue(this.entityId);
        }
        return Datamodel.makePropertyIdValue(this.entityId, this.siteIri);
    }

    @Override
    @JsonIgnore
    public EntityIdValue getEntityId() {
        return this.getPropertyId();
    }

    @Override
    @JsonIgnore
    public DatatypeIdValue getDatatype() {
        return new JacksonDatatypeId(this.datatype);
    }

    @Override
    public String getJsonType() {
        return "property";
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsPropertyDocument(this, obj);
    }

    public String toString() {
        return ToString.toString(this);
    }
}

