/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.json.jackson;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wikidata.wdtk.datamodel.helpers.DataModelConverter;
import org.wikidata.wdtk.datamodel.helpers.Datamodel;
import org.wikidata.wdtk.datamodel.interfaces.Claim;
import org.wikidata.wdtk.datamodel.interfaces.DataObjectFactory;
import org.wikidata.wdtk.datamodel.interfaces.DatatypeIdValue;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.GlobeCoordinatesValue;
import org.wikidata.wdtk.datamodel.interfaces.ItemDocument;
import org.wikidata.wdtk.datamodel.interfaces.ItemIdValue;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.NoValueSnak;
import org.wikidata.wdtk.datamodel.interfaces.PropertyDocument;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.QuantityValue;
import org.wikidata.wdtk.datamodel.interfaces.Reference;
import org.wikidata.wdtk.datamodel.interfaces.SiteLink;
import org.wikidata.wdtk.datamodel.interfaces.Snak;
import org.wikidata.wdtk.datamodel.interfaces.SnakGroup;
import org.wikidata.wdtk.datamodel.interfaces.SomeValueSnak;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementGroup;
import org.wikidata.wdtk.datamodel.interfaces.StatementRank;
import org.wikidata.wdtk.datamodel.interfaces.StringValue;
import org.wikidata.wdtk.datamodel.interfaces.TimeValue;
import org.wikidata.wdtk.datamodel.interfaces.Value;
import org.wikidata.wdtk.datamodel.interfaces.ValueSnak;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonItemDocument;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonMonolingualTextValue;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonNoValueSnak;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonPropertyDocument;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonReference;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonSiteLink;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonSnak;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonSomeValueSnak;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonStatement;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonTermedDocument;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonValueSnak;
import org.wikidata.wdtk.datamodel.json.jackson.datavalues.JacksonInnerEntityId;
import org.wikidata.wdtk.datamodel.json.jackson.datavalues.JacksonInnerGlobeCoordinates;
import org.wikidata.wdtk.datamodel.json.jackson.datavalues.JacksonInnerMonolingualText;
import org.wikidata.wdtk.datamodel.json.jackson.datavalues.JacksonInnerQuantity;
import org.wikidata.wdtk.datamodel.json.jackson.datavalues.JacksonInnerTime;
import org.wikidata.wdtk.datamodel.json.jackson.datavalues.JacksonValue;
import org.wikidata.wdtk.datamodel.json.jackson.datavalues.JacksonValueGlobeCoordinates;
import org.wikidata.wdtk.datamodel.json.jackson.datavalues.JacksonValueItemId;
import org.wikidata.wdtk.datamodel.json.jackson.datavalues.JacksonValueMonolingualText;
import org.wikidata.wdtk.datamodel.json.jackson.datavalues.JacksonValueQuantity;
import org.wikidata.wdtk.datamodel.json.jackson.datavalues.JacksonValueString;
import org.wikidata.wdtk.datamodel.json.jackson.datavalues.JacksonValueTime;

public class JacksonObjectFactory
implements DataObjectFactory {
    private final DataModelConverter dataModelConverter = new DataModelConverter(this);

    @Override
    public ItemIdValue getItemIdValue(String id, String siteIri) {
        if (id.length() > 0 && id.charAt(0) == 'Q') {
            Integer numericId = Integer.valueOf(id.substring(1));
            JacksonInnerEntityId innerEntity = new JacksonInnerEntityId("item", numericId);
            JacksonValueItemId result = new JacksonValueItemId();
            result.setValue(innerEntity);
            result.setParentDocument(this.getParentItemDocument("Qunknown", siteIri));
            return result;
        }
        throw new IllegalArgumentException("Illegal item id: " + id);
    }

    @Override
    public PropertyIdValue getPropertyIdValue(String id, String siteIri) {
        return Datamodel.makePropertyIdValue(id, siteIri);
    }

    @Override
    public DatatypeIdValue getDatatypeIdValue(String id) {
        return Datamodel.makeDatatypeIdValue(id);
    }

    @Override
    public TimeValue getTimeValue(long year, byte month, byte day, byte hour, byte minute, byte second, byte precision, int beforeTolerance, int afterTolerance, int timezoneOffset, String calendarModel) {
        JacksonInnerTime innerTime = new JacksonInnerTime(year, month, day, hour, minute, second, timezoneOffset, beforeTolerance, afterTolerance, precision, calendarModel);
        JacksonValueTime result = new JacksonValueTime();
        result.setValue(innerTime);
        return result;
    }

    @Override
    public GlobeCoordinatesValue getGlobeCoordinatesValue(long latitude, long longitude, long precision, String globeIri) {
        JacksonInnerGlobeCoordinates innerCoordinates = new JacksonInnerGlobeCoordinates(latitude, longitude, precision, globeIri);
        JacksonValueGlobeCoordinates result = new JacksonValueGlobeCoordinates();
        result.setValue(innerCoordinates);
        return result;
    }

    @Override
    public StringValue getStringValue(String string) {
        JacksonValueString result = new JacksonValueString();
        result.setValue(string);
        return result;
    }

    @Override
    public MonolingualTextValue getMonolingualTextValue(String text, String languageCode) {
        JacksonInnerMonolingualText innerMtlv = new JacksonInnerMonolingualText(languageCode, text);
        JacksonValueMonolingualText result = new JacksonValueMonolingualText();
        result.setValue(innerMtlv);
        return result;
    }

    @Override
    public QuantityValue getQuantityValue(BigDecimal numericValue, BigDecimal lowerBound, BigDecimal upperBound) {
        JacksonInnerQuantity innerQuantity = new JacksonInnerQuantity(numericValue, upperBound, lowerBound);
        JacksonValueQuantity result = new JacksonValueQuantity();
        result.setValue(innerQuantity);
        return result;
    }

    @Override
    public ValueSnak getValueSnak(PropertyIdValue propertyId, Value value) {
        JacksonValueSnak result = new JacksonValueSnak();
        result.setProperty(propertyId.getId());
        if (value instanceof JacksonValue) {
            return this.getJacksonValueSnak(propertyId, (JacksonValue)value, this.getDefaultJsonPropertyTypeForValueType(value));
        }
        return this.getJacksonValueSnak(propertyId, (JacksonValue)this.dataModelConverter.convertValue(value), this.getDefaultJsonPropertyTypeForValueType(value));
    }

    @Override
    public SomeValueSnak getSomeValueSnak(PropertyIdValue propertyId) {
        JacksonSomeValueSnak result = new JacksonSomeValueSnak();
        result.setProperty(propertyId.getId());
        result.setParentDocument(this.getParentItemDocument("Qundefined", propertyId.getSiteIri()));
        return result;
    }

    @Override
    public NoValueSnak getNoValueSnak(PropertyIdValue propertyId) {
        JacksonNoValueSnak result = new JacksonNoValueSnak();
        result.setProperty(propertyId.getId());
        result.setParentDocument(this.getParentItemDocument("Qundefined", propertyId.getSiteIri()));
        return result;
    }

    @Override
    public SnakGroup getSnakGroup(List<? extends Snak> snaks) {
        return Datamodel.makeSnakGroup(this.convertSnakList(snaks));
    }

    @Override
    public Claim getClaim(EntityIdValue subject, Snak mainSnak, List<SnakGroup> qualifiers) {
        Statement statement = this.getStatement(Datamodel.makeClaim(subject, mainSnak, qualifiers), Collections.emptyList(), StatementRank.NORMAL, "empty id 12345");
        return statement.getClaim();
    }

    @Override
    public Reference getReference(List<SnakGroup> snakGroups) {
        JacksonReference result = new JacksonReference();
        HashMap<String, List<JacksonSnak>> snakMap = new HashMap<String, List<JacksonSnak>>();
        ArrayList<String> propertyOrder = new ArrayList<String>(snakGroups.size());
        for (SnakGroup snakGroup : snakGroups) {
            snakMap.put(snakGroup.getProperty().getId(), this.convertSnakList(snakGroup.getSnaks()));
            propertyOrder.add(snakGroup.getProperty().getId());
        }
        result.setSnaks(snakMap);
        result.setPropertyOrder(propertyOrder);
        return result;
    }

    @Override
    public Statement getStatement(Claim claim, List<? extends Reference> references, StatementRank rank, String statementId) {
        JacksonStatement result = new JacksonStatement();
        if (claim.getMainSnak() instanceof JacksonSnak) {
            result.setMainsnak((JacksonSnak)claim.getMainSnak());
        } else {
            result.setMainsnak((JacksonSnak)this.dataModelConverter.convertSnak(claim.getMainSnak()));
        }
        HashMap<String, List<JacksonSnak>> qualifiers = new HashMap<String, List<JacksonSnak>>();
        ArrayList<String> propertyOrder = new ArrayList<String>(claim.getQualifiers().size());
        for (SnakGroup sg : claim.getQualifiers()) {
            qualifiers.put(sg.getProperty().getId(), this.convertSnakList(sg.getSnaks()));
            propertyOrder.add(sg.getProperty().getId());
        }
        result.setQualifiers(qualifiers);
        result.setPropertyOrder(propertyOrder);
        ArrayList<JacksonReference> jacksonReferences = new ArrayList<JacksonReference>(references.size());
        for (Reference reference : references) {
            if (reference instanceof JacksonReference) {
                jacksonReferences.add((JacksonReference)reference);
                continue;
            }
            jacksonReferences.add((JacksonReference)this.dataModelConverter.convert(reference));
        }
        result.setReferences(jacksonReferences);
        result.setRank(rank);
        result.setStatementId(statementId);
        result.setParentDocument(this.getParentItemDocument(claim.getSubject()));
        return result;
    }

    private JacksonItemDocument getParentItemDocument(EntityIdValue subject) {
        return this.getParentItemDocument(subject.getId(), subject.getSiteIri());
    }

    private JacksonItemDocument getParentItemDocument(String subjectId, String subjectSiteIri) {
        JacksonItemDocument helperParentDocument = new JacksonItemDocument();
        helperParentDocument.setJsonId(subjectId);
        helperParentDocument.setSiteIri(subjectSiteIri);
        return helperParentDocument;
    }

    @Override
    public StatementGroup getStatementGroup(List<Statement> statements) {
        ArrayList<Statement> newStatements = new ArrayList<Statement>(statements.size());
        for (Statement statement : statements) {
            if (statement instanceof JacksonStatement) {
                newStatements.add(statement);
                continue;
            }
            newStatements.add(this.dataModelConverter.convert(statement));
        }
        return Datamodel.makeStatementGroup(statements);
    }

    @Override
    public SiteLink getSiteLink(String title, String siteKey, List<String> badges) {
        JacksonSiteLink result = new JacksonSiteLink();
        result.setPageTitle(title);
        result.setSiteKey(siteKey);
        result.setBadges(badges);
        return result;
    }

    @Override
    public PropertyDocument getPropertyDocument(PropertyIdValue propertyId, List<MonolingualTextValue> labels, List<MonolingualTextValue> descriptions, List<MonolingualTextValue> aliases, DatatypeIdValue datatypeId) {
        JacksonPropertyDocument result = new JacksonPropertyDocument();
        this.initializeTermedDocument(result, propertyId, labels, descriptions, aliases);
        switch (datatypeId.getIri()) {
            case "http://www.wikidata.org/ontology#propertyTypeItem": {
                result.setJsonDatatype("wikibase-item");
                break;
            }
            case "http://www.wikidata.org/ontology#propertyTypeGlobeCoordinates": {
                result.setJsonDatatype("globe-coordinate");
                break;
            }
            case "http://www.wikidata.org/ontology#propertyTypeUrl": {
                result.setJsonDatatype("url");
                break;
            }
            case "http://www.wikidata.org/ontology#propertyTypeCommonsMedia": {
                result.setJsonDatatype("commonsMedia");
                break;
            }
            case "http://www.wikidata.org/ontology#propertyTypeTime": {
                result.setJsonDatatype("time");
                break;
            }
            case "http://www.wikidata.org/ontology#propertyTypeQuantity": {
                result.setJsonDatatype("quantity");
                break;
            }
            case "http://www.wikidata.org/ontology#propertyTypeString": {
                result.setJsonDatatype("string");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown datatype: " + datatypeId.getIri());
            }
        }
        return result;
    }

    @Override
    public ItemDocument getItemDocument(ItemIdValue itemIdValue, List<MonolingualTextValue> labels, List<MonolingualTextValue> descriptions, List<MonolingualTextValue> aliases, List<StatementGroup> statementGroups, Map<String, SiteLink> siteLinks) {
        JacksonItemDocument result = new JacksonItemDocument();
        this.initializeTermedDocument(result, itemIdValue, labels, descriptions, aliases);
        HashMap<String, List<JacksonStatement>> jacksonStatements = new HashMap<String, List<JacksonStatement>>();
        for (StatementGroup sg : statementGroups) {
            String propertyId = sg.getProperty().getId();
            ArrayList<JacksonStatement> propertyStatements = new ArrayList<JacksonStatement>(sg.getStatements().size());
            jacksonStatements.put(propertyId, propertyStatements);
            for (Statement s : sg) {
                if (s instanceof JacksonStatement) {
                    propertyStatements.add((JacksonStatement)s);
                    continue;
                }
                propertyStatements.add((JacksonStatement)this.dataModelConverter.convert(s));
            }
        }
        result.setJsonClaims(jacksonStatements);
        HashMap<String, JacksonSiteLink> jacksonSiteLinks = new HashMap<String, JacksonSiteLink>(siteLinks.size());
        for (SiteLink siteLink : siteLinks.values()) {
            if (siteLink instanceof JacksonSiteLink) {
                jacksonSiteLinks.put(siteLink.getSiteKey(), (JacksonSiteLink)siteLink);
                continue;
            }
            jacksonSiteLinks.put(siteLink.getSiteKey(), (JacksonSiteLink)this.dataModelConverter.convert(siteLink));
        }
        result.setSiteLinks(jacksonSiteLinks);
        return result;
    }

    private void initializeTermedDocument(JacksonTermedDocument document, EntityIdValue entityIdValue, List<MonolingualTextValue> labels, List<MonolingualTextValue> descriptions, List<MonolingualTextValue> aliases) {
        document.setJsonId(entityIdValue.getId());
        document.setSiteIri(entityIdValue.getSiteIri());
        HashMap<String, List<JacksonMonolingualTextValue>> aliasMap = new HashMap<String, List<JacksonMonolingualTextValue>>();
        for (MonolingualTextValue mltv : aliases) {
            ArrayList<JacksonMonolingualTextValue> langAliases = (ArrayList<JacksonMonolingualTextValue>)aliasMap.get(mltv.getLanguageCode());
            if (langAliases == null) {
                langAliases = new ArrayList<JacksonMonolingualTextValue>();
                aliasMap.put(mltv.getLanguageCode(), langAliases);
            }
            langAliases.add(this.convertMltv(mltv));
        }
        document.setAliases(aliasMap);
        document.setLabels(this.buildTermMapFromTermList(labels));
        document.setDescriptions(this.buildTermMapFromTermList(descriptions));
    }

    private Map<String, JacksonMonolingualTextValue> buildTermMapFromTermList(List<MonolingualTextValue> terms) {
        HashMap<String, JacksonMonolingualTextValue> result = new HashMap<String, JacksonMonolingualTextValue>(terms.size());
        for (MonolingualTextValue mltv : terms) {
            result.put(mltv.getLanguageCode(), this.convertMltv(mltv));
        }
        return result;
    }

    private JacksonMonolingualTextValue convertMltv(MonolingualTextValue mltv) {
        if (mltv instanceof JacksonMonolingualTextValue) {
            return (JacksonMonolingualTextValue)mltv;
        }
        return new JacksonMonolingualTextValue(mltv);
    }

    private ValueSnak getJacksonValueSnak(PropertyIdValue propertyId, JacksonValue value, String propertyDatatype) {
        JacksonValueSnak result = new JacksonValueSnak();
        result.setProperty(propertyId.getId());
        result.setDatavalue(value);
        result.setDatatype(propertyDatatype);
        result.setParentDocument(this.getParentItemDocument("Qundefined", propertyId.getSiteIri()));
        return result;
    }

    private String getDefaultJsonPropertyTypeForValueType(Value value) {
        if (value instanceof TimeValue) {
            return "time";
        }
        if (value instanceof ItemIdValue) {
            return "wikibase-item";
        }
        if (value instanceof StringValue) {
            return "string";
        }
        if (value instanceof GlobeCoordinatesValue) {
            return "globe-coordinate";
        }
        if (value instanceof QuantityValue) {
            return "quantity";
        }
        if (value instanceof MonolingualTextValue) {
            return "monolingualtext ";
        }
        throw new UnsupportedOperationException("Unsupported value type " + value.getClass());
    }

    private List<JacksonSnak> convertSnakList(List<? extends Snak> snaks) {
        ArrayList<JacksonSnak> result = new ArrayList<JacksonSnak>(snaks.size());
        for (Snak snak : snaks) {
            if (snak instanceof JacksonSnak) {
                result.add((JacksonSnak)snak);
                continue;
            }
            result.add((JacksonSnak)this.dataModelConverter.convertSnak(snak));
        }
        return result;
    }
}

