/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.json.jackson;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.ValueVisitor;

@JsonIgnoreProperties(ignoreUnknown=true)
public class JacksonMonolingualTextValue
implements MonolingualTextValue {
    private String languageCode;
    private String text;

    public JacksonMonolingualTextValue() {
    }

    public JacksonMonolingualTextValue(String languageCode, String text) {
        this.languageCode = languageCode;
        this.text = text;
    }

    public JacksonMonolingualTextValue(MonolingualTextValue mltv) {
        this(mltv.getLanguageCode(), mltv.getText());
    }

    @JsonProperty(value="language")
    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    @JsonProperty(value="value")
    public void setText(String text) {
        this.text = text;
    }

    @Override
    public <T> T accept(ValueVisitor<T> valueVisitor) {
        return valueVisitor.visit(this);
    }

    @Override
    @JsonProperty(value="value")
    public String getText() {
        return this.text;
    }

    @Override
    @JsonProperty(value="language")
    public String getLanguageCode() {
        return this.languageCode;
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsMonolingualTextValue(this, obj);
    }

    public String toString() {
        return ToString.toString(this);
    }
}

