/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.json.jackson;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.wikidata.wdtk.datamodel.helpers.Datamodel;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.ItemDocument;
import org.wikidata.wdtk.datamodel.interfaces.ItemIdValue;
import org.wikidata.wdtk.datamodel.interfaces.SiteLink;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementGroup;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonSiteLink;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonStatement;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonTermedDocument;
import org.wikidata.wdtk.datamodel.json.jackson.StatementGroupFromJson;
import org.wikidata.wdtk.util.NestedIterator;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonIgnoreProperties(ignoreUnknown=true)
public class JacksonItemDocument
extends JacksonTermedDocument
implements ItemDocument {
    Map<String, List<JacksonStatement>> claims = new HashMap<String, List<JacksonStatement>>();
    private Map<String, JacksonSiteLink> sitelinks = new HashMap<String, JacksonSiteLink>();
    private List<StatementGroup> statementGroups = null;

    @Override
    public String getJsonType() {
        return "item";
    }

    @Override
    @JsonIgnore
    public ItemIdValue getItemId() {
        if (this.siteIri == null) {
            return Datamodel.makeWikidataItemIdValue(this.entityId);
        }
        return Datamodel.makeItemIdValue(this.entityId, this.siteIri);
    }

    @Override
    @JsonIgnore
    public EntityIdValue getEntityId() {
        return this.getItemId();
    }

    @Override
    @JsonIgnore
    public List<StatementGroup> getStatementGroups() {
        if (this.statementGroups == null) {
            this.statementGroups = new ArrayList<StatementGroup>(this.claims.size());
            for (List<JacksonStatement> statements : this.claims.values()) {
                this.statementGroups.add(new StatementGroupFromJson(statements));
            }
        }
        return this.statementGroups;
    }

    @JsonProperty(value="sitelinks")
    public void setSiteLinks(Map<String, JacksonSiteLink> sitelinks) {
        this.sitelinks = sitelinks;
    }

    @Override
    @JsonProperty(value="sitelinks")
    public Map<String, SiteLink> getSiteLinks() {
        return Collections.unmodifiableMap(this.sitelinks);
    }

    @JsonProperty(value="claims")
    public void setJsonClaims(Map<String, List<JacksonStatement>> claims) {
        this.claims = claims;
        this.statementGroups = null;
        this.updateClaims();
    }

    private void updateClaims() {
        this.statementGroups = null;
        for (Map.Entry<String, List<JacksonStatement>> entry : this.claims.entrySet()) {
            for (JacksonStatement statement : entry.getValue()) {
                statement.setParentDocument(this);
            }
        }
    }

    @JsonProperty(value="claims")
    public Map<String, List<JacksonStatement>> getJsonClaims() {
        return this.claims;
    }

    @Override
    public Iterator<Statement> getAllStatements() {
        return new NestedIterator(this.getStatementGroups());
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsItemDocument(this, obj);
    }

    public String toString() {
        return ToString.toString(this);
    }
}

