/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.json.jackson;

import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.interfaces.DatatypeIdValue;
import org.wikidata.wdtk.datamodel.interfaces.ValueVisitor;

public class JacksonDatatypeId
implements DatatypeIdValue {
    public static final String JSON_DT_ITEM = "wikibase-item";
    public static final String JSON_DT_GLOBE_COORDINATES = "globe-coordinate";
    public static final String JSON_DT_URL = "url";
    public static final String JSON_DT_COMMONS_MEDIA = "commonsMedia";
    public static final String JSON_DT_TIME = "time";
    public static final String JSON_DT_QUANTITY = "quantity";
    public static final String JSON_DT_STRING = "string";
    public static final String JSON_DT_MONOLINGUAL_TEXT = "monolingualtext ";
    private final String iri;

    public static String getDatatypeIriFromJsonDatatype(String jsonDatatype) {
        switch (jsonDatatype) {
            case "wikibase-item": {
                return "http://www.wikidata.org/ontology#propertyTypeItem";
            }
            case "globe-coordinate": {
                return "http://www.wikidata.org/ontology#propertyTypeGlobeCoordinates";
            }
            case "url": {
                return "http://www.wikidata.org/ontology#propertyTypeUrl";
            }
            case "commonsMedia": {
                return "http://www.wikidata.org/ontology#propertyTypeCommonsMedia";
            }
            case "time": {
                return "http://www.wikidata.org/ontology#propertyTypeTime";
            }
            case "quantity": {
                return "http://www.wikidata.org/ontology#propertyTypeQuantity";
            }
            case "string": {
                return "http://www.wikidata.org/ontology#propertyTypeString";
            }
            case "monolingualtext ": {
                return "http://www.wikidata.org/ontology#propertyTypeMonolingualText";
            }
        }
        throw new IllegalArgumentException("Unknown JSON datatype \"" + jsonDatatype + "\"");
    }

    public JacksonDatatypeId(String jsonDatatype) throws IllegalArgumentException {
        this.iri = JacksonDatatypeId.getDatatypeIriFromJsonDatatype(jsonDatatype);
    }

    @Override
    public String getIri() {
        return this.iri;
    }

    @Override
    public <T> T accept(ValueVisitor<T> valueVisitor) {
        return valueVisitor.visit(this);
    }

    public String toString() {
        return ToString.toString(this);
    }

    public boolean equals(Object o) {
        return Equality.equalsDatatypeIdValue(this, o);
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }
}

