/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.json.jackson;

import java.util.Iterator;
import java.util.List;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.interfaces.Claim;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.Snak;
import org.wikidata.wdtk.datamodel.interfaces.SnakGroup;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonItemDocument;
import org.wikidata.wdtk.datamodel.json.jackson.JacksonStatement;
import org.wikidata.wdtk.datamodel.json.jackson.SnakGroupFromJson;
import org.wikidata.wdtk.util.NestedIterator;

public class ClaimFromJson
implements Claim {
    private final JacksonStatement statement;
    private List<SnakGroup> qualifiers = null;

    public ClaimFromJson(JacksonStatement statement) {
        this.statement = statement;
    }

    @Override
    public EntityIdValue getSubject() {
        JacksonItemDocument parentDocument = this.statement.getParentDocument();
        if (parentDocument != null) {
            return parentDocument.getEntityId();
        }
        return null;
    }

    @Override
    public Snak getMainSnak() {
        return this.statement.getMainsnak();
    }

    @Override
    public List<SnakGroup> getQualifiers() {
        if (this.qualifiers == null) {
            this.qualifiers = SnakGroupFromJson.makeSnakGroups(this.statement.getQualifiers(), this.statement.getPropertyOrder());
        }
        return this.qualifiers;
    }

    @Override
    public Iterator<Snak> getAllQualifiers() {
        return new NestedIterator(this.getQualifiers());
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsClaim(this, obj);
    }

    public String toString() {
        return ToString.toString(this);
    }
}

