/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.json;

import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.wikidata.wdtk.datamodel.interfaces.Claim;
import org.wikidata.wdtk.datamodel.interfaces.ItemDocument;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.PropertyDocument;
import org.wikidata.wdtk.datamodel.interfaces.Reference;
import org.wikidata.wdtk.datamodel.interfaces.SiteLink;
import org.wikidata.wdtk.datamodel.interfaces.Snak;
import org.wikidata.wdtk.datamodel.interfaces.SnakGroup;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementGroup;
import org.wikidata.wdtk.datamodel.interfaces.StatementRank;
import org.wikidata.wdtk.datamodel.interfaces.TermedDocument;
import org.wikidata.wdtk.datamodel.json.SnakJsonConverter;
import org.wikidata.wdtk.datamodel.json.ValueJsonConverter;

public class JsonConverter {
    final ValueJsonConverter valueJsonConverter = new ValueJsonConverter();
    final SnakJsonConverter snakJsonConverter = new SnakJsonConverter(this.valueJsonConverter);

    public JSONObject getJsonForItemDocument(ItemDocument document) {
        JSONObject result = new JSONObject();
        JSONObject statementGroups = new JSONObject();
        result = this.addTermedDocumentAttributes(document, result);
        result.put("type", (Object)"item");
        if (!document.getStatementGroups().isEmpty()) {
            result.put("claims", (Object)statementGroups);
        }
        if (!document.getSiteLinks().isEmpty()) {
            result.put("sitelinks", (Object)this.convertSiteLinksToJson(document));
        }
        for (StatementGroup statementGroup : document.getStatementGroups()) {
            statementGroups.put(statementGroup.getProperty().getId().toString(), (Object)this.convertStatementGroupToJson(statementGroup));
        }
        return result;
    }

    public JSONObject getJsonForPropertyDocument(PropertyDocument document) {
        JSONObject result = new JSONObject();
        result.put("type", (Object)"property");
        result = this.addTermedDocumentAttributes(document, result);
        return result;
    }

    JSONObject convertAliasesToJson(TermedDocument document) {
        JSONObject result = new JSONObject();
        for (String key : document.getAliases().keySet()) {
            JSONArray alias = new JSONArray();
            result.put(key, (Object)alias);
            for (MonolingualTextValue value : document.getAliases().get(key)) {
                alias.put((Object)value.accept(this.valueJsonConverter));
            }
        }
        return result;
    }

    JSONObject convertDescriptionsToJson(TermedDocument document) {
        JSONObject result = new JSONObject();
        for (String key : document.getDescriptions().keySet()) {
            result.put(key, (Object)document.getDescriptions().get(key).accept(this.valueJsonConverter));
        }
        return result;
    }

    JSONObject convertLabelsToJson(TermedDocument document) {
        JSONObject result = new JSONObject();
        for (String key : document.getLabels().keySet()) {
            result.put(key, (Object)document.getLabels().get(key).accept(this.valueJsonConverter));
        }
        return result;
    }

    JSONObject convertSiteLinksToJson(ItemDocument document) {
        JSONObject result = new JSONObject();
        for (String key : document.getSiteLinks().keySet()) {
            result.put(key, (Object)this.getJsonForSiteLink(document.getSiteLinks().get(key)));
        }
        return result;
    }

    JSONObject convertQualifiersToJson(List<SnakGroup> qualifiers) {
        JSONObject result = new JSONObject();
        for (SnakGroup snakGroup : qualifiers) {
            String pId = snakGroup.getProperty().getId();
            JSONArray jsonArray = new JSONArray();
            result.put(pId, (Object)jsonArray);
            for (Snak snak : snakGroup.getSnaks()) {
                jsonArray.put((Object)snak.accept(this.snakJsonConverter));
            }
        }
        return result;
    }

    JSONObject addTermedDocumentAttributes(TermedDocument document, JSONObject elem) {
        JSONObject result = elem;
        result.put("id", (Object)document.getEntityId().getId());
        result.put("title", (Object)document.getEntityId().getId());
        if (!document.getAliases().isEmpty()) {
            result.put("aliases", (Object)this.convertAliasesToJson(document));
        }
        if (!document.getDescriptions().isEmpty()) {
            result.put("descriptions", (Object)this.convertDescriptionsToJson(document));
        }
        if (!document.getLabels().isEmpty()) {
            result.put("labels", (Object)this.convertLabelsToJson(document));
        }
        return result;
    }

    JSONObject getJsonForClaim(Claim claim) {
        JSONObject result = new JSONObject();
        JSONArray order = new JSONArray();
        result.put("mainsnak", (Object)claim.getMainSnak().accept(this.snakJsonConverter));
        if (!claim.getQualifiers().isEmpty()) {
            result.put("qualifiers", (Object)this.convertQualifiersToJson(claim.getQualifiers()));
            result.put("qualifiers-order", (Object)order);
            for (SnakGroup snakGroup : claim.getQualifiers()) {
                order.put((Object)snakGroup.getProperty().getId());
            }
        }
        return result;
    }

    JSONObject getJsonForReference(Reference reference) {
        JSONObject snaks = new JSONObject();
        JSONArray snakOrder = new JSONArray();
        for (SnakGroup snakGroup : reference.getSnakGroups()) {
            String pId = snakGroup.getProperty().getId();
            JSONArray group = new JSONArray();
            snaks.put(pId, (Object)group);
            snakOrder.put((Object)pId);
            for (Snak snak : snakGroup.getSnaks()) {
                group.put((Object)snak.accept(this.snakJsonConverter));
            }
        }
        JSONObject result = new JSONObject();
        result.put("snaks", (Object)snaks);
        result.put("snak-order", (Object)snakOrder);
        return result;
    }

    JSONObject getJsonForStatement(Statement statement) {
        JSONObject result = new JSONObject();
        result = this.getJsonForClaim(statement.getClaim());
        result.put("id", (Object)statement.getStatementId());
        result.put("type", (Object)"statement");
        result.put("rank", (Object)this.convertStatementRankToJson(statement.getRank()));
        JSONArray references = new JSONArray();
        if (!statement.getReferences().isEmpty()) {
            result.put("references", (Object)references);
        }
        for (Reference reference : statement.getReferences()) {
            references.put((Object)this.getJsonForReference(reference));
        }
        return result;
    }

    JSONArray convertStatementGroupToJson(StatementGroup statementGroup) {
        JSONArray statements = new JSONArray();
        for (Statement statement : statementGroup.getStatements()) {
            statements.put((Object)this.getJsonForStatement(statement));
        }
        return statements;
    }

    JSONObject getJsonForSiteLink(SiteLink link) {
        JSONObject result = new JSONObject();
        result.put("site", (Object)link.getSiteKey());
        result.put("title", (Object)link.getPageTitle());
        result.put("badges", (Object)new JSONArray());
        return result;
    }

    String convertStatementRankToJson(StatementRank rank) {
        switch (rank) {
            case PREFERRED: {
                return "preferred";
            }
            case NORMAL: {
                return "normal";
            }
            case DEPRECATED: {
                return "deprecated";
            }
        }
        throw new IllegalArgumentException("Unknown rank " + rank.toString());
    }
}

