/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.interfaces.SiteLink;

public class SiteLinkImpl
implements SiteLink {
    final String title;
    final String siteKey;
    final List<String> badges;

    SiteLinkImpl(String title, String siteKey, List<String> badges) {
        Validate.notNull((Object)title, (String)"title cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)siteKey, (String)"siteKey cannot be null", (Object[])new Object[0]);
        Validate.notNull(badges, (String)"list of badges cannot be null", (Object[])new Object[0]);
        this.title = title;
        this.siteKey = siteKey;
        this.badges = badges;
    }

    @Override
    public String getPageTitle() {
        return this.title;
    }

    @Override
    public String getSiteKey() {
        return this.siteKey;
    }

    @Override
    public List<String> getBadges() {
        return Collections.unmodifiableList(this.badges);
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsSiteLink(this, obj);
    }

    public String toString() {
        return ToString.toString(this);
    }
}

