/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.interfaces.Reference;
import org.wikidata.wdtk.datamodel.interfaces.Snak;
import org.wikidata.wdtk.datamodel.interfaces.SnakGroup;
import org.wikidata.wdtk.util.NestedIterator;

public class ReferenceImpl
implements Reference {
    List<? extends SnakGroup> snakGroups;

    ReferenceImpl(List<SnakGroup> snakGroups) {
        Validate.notNull(snakGroups, (String)"List of snak groups cannot be null", (Object[])new Object[0]);
        this.snakGroups = snakGroups;
    }

    @Override
    public List<SnakGroup> getSnakGroups() {
        return Collections.unmodifiableList(this.snakGroups);
    }

    @Override
    public Iterator<Snak> getAllSnaks() {
        return new NestedIterator(this.snakGroups);
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsReference(this, obj);
    }

    public String toString() {
        return ToString.toString(this);
    }
}

