/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.ValueVisitor;

public abstract class EntityIdValueImpl
implements EntityIdValue {
    final String id;
    final String siteIri;

    EntityIdValueImpl(String id, String siteIri) {
        Validate.notNull((Object)id, (String)"Entity ids cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)siteIri, (String)"Entity site IRIs cannot be null", (Object[])new Object[0]);
        this.id = id;
        this.siteIri = siteIri;
    }

    @Override
    public String getIri() {
        return this.siteIri.concat(this.id);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getSiteIri() {
        return this.siteIri;
    }

    @Override
    public <T> T accept(ValueVisitor<T> valueVisitor) {
        return valueVisitor.visit(this);
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsEntityIdValue(this, obj);
    }
}

