/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.interfaces;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.wikidata.wdtk.datamodel.interfaces.EntityDocument;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.GlobeCoordinatesValue;
import org.wikidata.wdtk.datamodel.interfaces.ItemIdValue;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.QuantityValue;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementGroup;
import org.wikidata.wdtk.datamodel.interfaces.StringValue;
import org.wikidata.wdtk.datamodel.interfaces.TimeValue;
import org.wikidata.wdtk.datamodel.interfaces.Value;
import org.wikidata.wdtk.util.NestedIterator;

public interface StatementDocument
extends EntityDocument {
    public List<StatementGroup> getStatementGroups();

    default public Iterator<Statement> getAllStatements() {
        return new NestedIterator(this.getStatementGroups());
    }

    default public StatementGroup findStatementGroup(PropertyIdValue propertyIdValue) {
        for (StatementGroup sg : this.getStatementGroups()) {
            if (!propertyIdValue.equals(sg.getProperty())) continue;
            return sg;
        }
        return null;
    }

    default public StatementGroup findStatementGroup(String propertyId) {
        for (StatementGroup sg : this.getStatementGroups()) {
            if (!propertyId.equals(sg.getProperty().getId())) continue;
            return sg;
        }
        return null;
    }

    default public boolean hasStatement(PropertyIdValue propertyIdValue) {
        return this.findStatementGroup(propertyIdValue) != null;
    }

    default public boolean hasStatement(String propertyId) {
        return this.findStatementGroup(propertyId) != null;
    }

    default public boolean hasStatementValue(PropertyIdValue propertyIdValue, Value value) {
        return this.hasStatementValue(propertyIdValue, Collections.singleton(value));
    }

    default public boolean hasStatementValue(String propertyId, Value value) {
        return this.hasStatementValue(propertyId, Collections.singleton(value));
    }

    default public boolean hasStatementValue(PropertyIdValue propertyIdValue, Set<? extends Value> values) {
        StatementGroup statementGroup = this.findStatementGroup(propertyIdValue);
        if (statementGroup == null) {
            return false;
        }
        for (Statement statement : statementGroup) {
            if (!values.contains(statement.getValue())) continue;
            return true;
        }
        return false;
    }

    default public boolean hasStatementValue(String propertyId, Set<? extends Value> values) {
        StatementGroup statementGroup = this.findStatementGroup(propertyId);
        if (statementGroup == null) {
            return false;
        }
        for (Statement statement : statementGroup) {
            if (!values.contains(statement.getValue())) continue;
            return true;
        }
        return false;
    }

    default public Statement findStatement(PropertyIdValue propertyIdValue) {
        StatementGroup statementGroup = this.findStatementGroup(propertyIdValue);
        return statementGroup != null && statementGroup.size() == 1 ? statementGroup.getStatements().get(0) : null;
    }

    default public Statement findStatement(String propertyId) {
        StatementGroup statementGroup = this.findStatementGroup(propertyId);
        return statementGroup != null && statementGroup.size() == 1 ? statementGroup.getStatements().get(0) : null;
    }

    default public Value findStatementValue(PropertyIdValue propertyIdValue) {
        Statement statement = this.findStatement(propertyIdValue);
        return statement != null ? statement.getValue() : null;
    }

    default public Value findStatementValue(String propertyId) {
        Statement statement = this.findStatement(propertyId);
        return statement != null ? statement.getValue() : null;
    }

    default public StringValue findStatementStringValue(PropertyIdValue propertyIdValue) {
        Value value = this.findStatementValue(propertyIdValue);
        return value instanceof StringValue ? (StringValue)value : null;
    }

    default public StringValue findStatementStringValue(String propertyId) {
        Value value = this.findStatementValue(propertyId);
        return value instanceof StringValue ? (StringValue)value : null;
    }

    default public QuantityValue findStatementQuantityValue(PropertyIdValue propertyIdValue) {
        Value value = this.findStatementValue(propertyIdValue);
        return value instanceof QuantityValue ? (QuantityValue)value : null;
    }

    default public QuantityValue findStatementQuantityValue(String propertyId) {
        Value value = this.findStatementValue(propertyId);
        return value instanceof QuantityValue ? (QuantityValue)value : null;
    }

    default public GlobeCoordinatesValue findStatementGlobeCoordinatesValue(PropertyIdValue propertyIdValue) {
        Value value = this.findStatementValue(propertyIdValue);
        return value instanceof GlobeCoordinatesValue ? (GlobeCoordinatesValue)value : null;
    }

    default public GlobeCoordinatesValue findStatementGlobeCoordinatesValue(String propertyId) {
        Value value = this.findStatementValue(propertyId);
        return value instanceof GlobeCoordinatesValue ? (GlobeCoordinatesValue)value : null;
    }

    default public TimeValue findStatementTimeValue(PropertyIdValue propertyIdValue) {
        Value value = this.findStatementValue(propertyIdValue);
        return value instanceof TimeValue ? (TimeValue)value : null;
    }

    default public TimeValue findStatementTimeValue(String propertyId) {
        Value value = this.findStatementValue(propertyId);
        return value instanceof TimeValue ? (TimeValue)value : null;
    }

    default public MonolingualTextValue findStatementMonolingualTextValue(PropertyIdValue propertyIdValue) {
        Value value = this.findStatementValue(propertyIdValue);
        return value instanceof MonolingualTextValue ? (MonolingualTextValue)value : null;
    }

    default public MonolingualTextValue findStatementMonolingualTextValue(String propertyId) {
        Value value = this.findStatementValue(propertyId);
        return value instanceof MonolingualTextValue ? (MonolingualTextValue)value : null;
    }

    default public ItemIdValue findStatementItemIdValue(PropertyIdValue propertyIdValue) {
        Value value = this.findStatementValue(propertyIdValue);
        return value instanceof ItemIdValue ? (ItemIdValue)value : null;
    }

    default public ItemIdValue findStatementItemIdValue(String propertyId) {
        Value value = this.findStatementValue(propertyId);
        return value instanceof ItemIdValue ? (ItemIdValue)value : null;
    }

    default public PropertyIdValue findStatementPropertyIdValue(PropertyIdValue propertyIdValue) {
        Value value = this.findStatementValue(propertyIdValue);
        return value instanceof PropertyIdValue ? (PropertyIdValue)value : null;
    }

    default public PropertyIdValue findStatementPropertyIdValue(String propertyId) {
        Value value = this.findStatementValue(propertyId);
        return value instanceof PropertyIdValue ? (PropertyIdValue)value : null;
    }

    default public EntityIdValue findStatementEntityIdValue(PropertyIdValue propertyIdValue) {
        Value value = this.findStatementValue(propertyIdValue);
        return value instanceof EntityIdValue ? (EntityIdValue)value : null;
    }

    default public EntityIdValue findStatementEntityIdValue(String propertyId) {
        Value value = this.findStatementValue(propertyId);
        return value instanceof EntityIdValue ? (EntityIdValue)value : null;
    }

    @Override
    public StatementDocument withRevisionId(long var1);

    public StatementDocument withStatement(Statement var1);

    public StatementDocument withoutStatementIds(Set<String> var1);
}

