/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.implementation.TermImpl;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.TermUpdate;

public class TermUpdateImpl
implements TermUpdate {
    @JsonIgnore
    private final Map<String, MonolingualTextValue> modified;
    @JsonIgnore
    private final Set<String> removed;

    public TermUpdateImpl(Collection<MonolingualTextValue> modified, Collection<String> removed) {
        Objects.requireNonNull(modified, "Collection of modified terms cannot be null.");
        Objects.requireNonNull(removed, "Collection of removed terms cannot be null.");
        for (MonolingualTextValue value : modified) {
            Objects.requireNonNull(value, "Modified term cannot be null.");
        }
        for (String language : removed) {
            Validate.notBlank((CharSequence)language, (String)"Language code must be a non-blank string.", (Object[])new Object[0]);
        }
        long distinct = Stream.concat(removed.stream(), modified.stream().map(v -> v.getLanguageCode())).distinct().count();
        Validate.isTrue((distinct == (long)(modified.size() + removed.size()) ? 1 : 0) != 0, (String)"Every term must have unique language code.", (Object[])new Object[0]);
        this.modified = Collections.unmodifiableMap(modified.stream().map(TermImpl::new).collect(Collectors.toMap(v -> v.getLanguageCode(), r -> r)));
        this.removed = Collections.unmodifiableSet(new HashSet<String>(removed));
    }

    @Override
    @JsonIgnore
    public boolean isEmpty() {
        return this.modified.isEmpty() && this.removed.isEmpty();
    }

    @Override
    @JsonIgnore
    public Map<String, MonolingualTextValue> getModified() {
        return this.modified;
    }

    @Override
    @JsonIgnore
    public Set<String> getRemoved() {
        return this.removed;
    }

    @JsonValue
    Map<String, Object> toJson() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (MonolingualTextValue value : this.modified.values()) {
            map.put(value.getLanguageCode(), value);
        }
        for (String language : this.removed) {
            map.put(language, new RemovedTerm(language));
        }
        return map;
    }

    public boolean equals(Object obj) {
        return Equality.equalsTermUpdate(this, obj);
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    static class RemovedTerm {
        private final String language;

        RemovedTerm(String language) {
            this.language = language;
        }

        @JsonProperty
        String getLanguage() {
            return this.language;
        }

        @JsonProperty(value="remove")
        String getRemoveCommand() {
            return "";
        }
    }
}

