/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.implementation.FormDocumentImpl;
import org.wikidata.wdtk.datamodel.implementation.SenseDocumentImpl;
import org.wikidata.wdtk.datamodel.implementation.StatementDocumentUpdateImpl;
import org.wikidata.wdtk.datamodel.interfaces.FormDocument;
import org.wikidata.wdtk.datamodel.interfaces.FormIdValue;
import org.wikidata.wdtk.datamodel.interfaces.FormUpdate;
import org.wikidata.wdtk.datamodel.interfaces.ItemIdValue;
import org.wikidata.wdtk.datamodel.interfaces.LexemeIdValue;
import org.wikidata.wdtk.datamodel.interfaces.LexemeUpdate;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.SenseDocument;
import org.wikidata.wdtk.datamodel.interfaces.SenseIdValue;
import org.wikidata.wdtk.datamodel.interfaces.SenseUpdate;
import org.wikidata.wdtk.datamodel.interfaces.StatementUpdate;
import org.wikidata.wdtk.datamodel.interfaces.TermUpdate;

public class LexemeUpdateImpl
extends StatementDocumentUpdateImpl
implements LexemeUpdate {
    @JsonIgnore
    private final ItemIdValue language;
    @JsonIgnore
    private final ItemIdValue lexicalCategory;
    @JsonIgnore
    private final TermUpdate lemmas;
    @JsonIgnore
    private final List<SenseDocument> addedSenses;
    @JsonIgnore
    private final Map<SenseIdValue, SenseUpdate> updatedSenses;
    @JsonIgnore
    private final Set<SenseIdValue> removedSenses;
    @JsonIgnore
    private final List<FormDocument> addedForms;
    @JsonIgnore
    private final Map<FormIdValue, FormUpdate> updatedForms;
    @JsonIgnore
    private final Set<FormIdValue> removedForms;

    public LexemeUpdateImpl(LexemeIdValue entityId, long revisionId, ItemIdValue language, ItemIdValue lexicalCategory, TermUpdate lemmas, StatementUpdate statements, Collection<SenseDocument> addedSenses, Collection<SenseUpdate> updatedSenses, Collection<SenseIdValue> removedSenses, Collection<FormDocument> addedForms, Collection<FormUpdate> updatedForms, Collection<FormIdValue> removedForms) {
        super(entityId, revisionId, statements);
        Validate.isTrue((language == null || !language.isPlaceholder() ? 1 : 0) != 0, (String)"Language cannot be a placeholder ID.", (Object[])new Object[0]);
        this.language = language;
        Validate.isTrue((lexicalCategory == null || !lexicalCategory.isPlaceholder() ? 1 : 0) != 0, (String)"Lexical category cannot be a placeholder ID.", (Object[])new Object[0]);
        this.lexicalCategory = lexicalCategory;
        Objects.requireNonNull(lemmas, "Lemma update cannot be null.");
        this.lemmas = lemmas;
        Objects.requireNonNull(addedSenses, "List of added senses cannot be null.");
        for (SenseDocument senseDocument : addedSenses) {
            Objects.requireNonNull(senseDocument, "Added sense cannot be null.");
            Validate.isTrue((boolean)senseDocument.getEntityId().isPlaceholder(), (String)"Added sense must have placeholder ID.", (Object[])new Object[0]);
        }
        this.addedSenses = Collections.unmodifiableList(new ArrayList<SenseDocument>(addedSenses));
        Objects.requireNonNull(updatedSenses, "List of sense updates cannot be null.");
        for (SenseUpdate senseUpdate : updatedSenses) {
            Objects.requireNonNull(senseUpdate, "Sense update cannot be null.");
            Validate.isTrue((senseUpdate.getBaseRevisionId() == revisionId ? 1 : 0) != 0, (String)"Nested sense update must have the same revision ID as lexeme update.", (Object[])new Object[0]);
        }
        Validate.isTrue((updatedSenses.stream().map(s -> s.getEntityId()).distinct().count() == (long)updatedSenses.size() ? 1 : 0) != 0, (String)"Cannot apply two updates to the same sense.", (Object[])new Object[0]);
        this.updatedSenses = Collections.unmodifiableMap(updatedSenses.stream().filter(s -> !s.isEmpty()).collect(Collectors.toMap(s -> s.getEntityId(), s -> s)));
        Objects.requireNonNull(removedSenses, "List of removed sense IDs cannot be null.");
        for (SenseIdValue senseIdValue : removedSenses) {
            Objects.requireNonNull(senseIdValue, "Removed sense cannot have null ID.");
            Validate.isTrue((!senseIdValue.isPlaceholder() ? 1 : 0) != 0, (String)"Removed sense cannot have placeholder ID.", (Object[])new Object[0]);
        }
        Validate.isTrue((removedSenses.stream().distinct().count() == (long)removedSenses.size() ? 1 : 0) != 0, (String)"Cannot remove the same sense twice.", (Object[])new Object[0]);
        this.removedSenses = Collections.unmodifiableSet(new HashSet<SenseIdValue>(removedSenses));
        Validate.isTrue((boolean)updatedSenses.stream().noneMatch(s -> this.removedSenses.contains(s.getEntityId())), (String)"Cannot remove sense that is being updated.", (Object[])new Object[0]);
        Objects.requireNonNull(addedForms, "List of added forms cannot be null.");
        for (FormDocument formDocument : addedForms) {
            Objects.requireNonNull(formDocument, "Added form cannot be null.");
            Validate.isTrue((boolean)formDocument.getEntityId().isPlaceholder(), (String)"Added form must have placeholder ID.", (Object[])new Object[0]);
        }
        this.addedForms = Collections.unmodifiableList(new ArrayList<FormDocument>(addedForms));
        Objects.requireNonNull(updatedForms, "List of form updates cannot be null.");
        for (FormUpdate formUpdate : updatedForms) {
            Objects.requireNonNull(formUpdate, "Form update cannot be null.");
            Validate.isTrue((formUpdate.getBaseRevisionId() == revisionId ? 1 : 0) != 0, (String)"Nested form update must have the same revision ID as lexeme update.", (Object[])new Object[0]);
        }
        Validate.isTrue((updatedForms.stream().map(s -> s.getEntityId()).distinct().count() == (long)updatedForms.size() ? 1 : 0) != 0, (String)"Cannot apply two updates to the same form.", (Object[])new Object[0]);
        this.updatedForms = Collections.unmodifiableMap(updatedForms.stream().filter(f -> !f.isEmpty()).collect(Collectors.toMap(f -> f.getEntityId(), f -> f)));
        Objects.requireNonNull(removedForms, "List of removed form IDs cannot be null.");
        for (FormIdValue formIdValue : removedForms) {
            Objects.requireNonNull(formIdValue, "Removed form cannot have null ID.");
            Validate.isTrue((!formIdValue.isPlaceholder() ? 1 : 0) != 0, (String)"Removed form cannot have placeholder ID.", (Object[])new Object[0]);
        }
        Validate.isTrue((removedForms.stream().distinct().count() == (long)removedForms.size() ? 1 : 0) != 0, (String)"Cannot remove the same form twice.", (Object[])new Object[0]);
        this.removedForms = Collections.unmodifiableSet(new HashSet<FormIdValue>(removedForms));
        Validate.isTrue((boolean)updatedForms.stream().noneMatch(s -> this.removedForms.contains(s.getEntityId())), (String)"Cannot remove form that is being updated.", (Object[])new Object[0]);
    }

    @Override
    @JsonIgnore
    public LexemeIdValue getEntityId() {
        return (LexemeIdValue)super.getEntityId();
    }

    @Override
    @JsonIgnore
    public boolean isEmpty() {
        return super.isEmpty() && this.language == null && this.lexicalCategory == null && this.lemmas.isEmpty() && this.addedSenses.isEmpty() && this.updatedSenses.isEmpty() && this.removedSenses.isEmpty() && this.addedForms.isEmpty() && this.updatedForms.isEmpty() && this.removedForms.isEmpty();
    }

    @Override
    @JsonIgnore
    public Optional<ItemIdValue> getLanguage() {
        return Optional.ofNullable(this.language);
    }

    @JsonProperty(value="language")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    String getJsonLanguage() {
        return this.language != null ? this.language.getId() : null;
    }

    @Override
    @JsonIgnore
    public Optional<ItemIdValue> getLexicalCategory() {
        return Optional.ofNullable(this.lexicalCategory);
    }

    @JsonProperty(value="lexicalCategory")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    String getJsonLexicalCategory() {
        return this.lexicalCategory != null ? this.lexicalCategory.getId() : null;
    }

    @Override
    @JsonIgnore
    public TermUpdate getLemmas() {
        return this.lemmas;
    }

    @JsonProperty(value="lemmas")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    TermUpdate getJsonLemmas() {
        return this.lemmas.isEmpty() ? null : this.lemmas;
    }

    @Override
    @JsonIgnore
    public List<SenseDocument> getAddedSenses() {
        return this.addedSenses;
    }

    @Override
    @JsonIgnore
    public Map<SenseIdValue, SenseUpdate> getUpdatedSenses() {
        return this.updatedSenses;
    }

    @Override
    @JsonIgnore
    public Set<SenseIdValue> getRemovedSenses() {
        return this.removedSenses;
    }

    @Override
    @JsonIgnore
    public List<FormDocument> getAddedForms() {
        return this.addedForms;
    }

    @Override
    @JsonIgnore
    public Map<FormIdValue, FormUpdate> getUpdatedForms() {
        return this.updatedForms;
    }

    @Override
    @JsonIgnore
    public Set<FormIdValue> getRemovedForms() {
        return this.removedForms;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    List<Object> getSenses() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (SenseDocument sense : this.addedSenses) {
            list.add(new AddedSense(sense));
        }
        list.addAll(this.updatedSenses.values());
        for (SenseIdValue id : this.removedSenses) {
            list.add(new RemovedSense(id));
        }
        return list;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    List<Object> getForms() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (FormDocument form : this.addedForms) {
            list.add(new AddedForm(form));
        }
        list.addAll(this.updatedForms.values());
        for (FormIdValue id : this.removedForms) {
            list.add(new RemovedForm(id));
        }
        return list;
    }

    public boolean equals(Object obj) {
        return Equality.equalsLexemeUpdate(this, obj);
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    static class RemovedForm {
        @JsonIgnore
        private final FormIdValue id;

        RemovedForm(FormIdValue id) {
            this.id = id;
        }

        @JsonProperty
        String getId() {
            return this.id.getId();
        }

        @JsonProperty(value="remove")
        String getRemoveCommand() {
            return "";
        }
    }

    static class AddedForm
    extends FormDocumentImpl {
        AddedForm(FormDocument form) {
            super(FormIdValue.NULL, new ArrayList<MonolingualTextValue>(form.getRepresentations().values()), form.getGrammaticalFeatures(), form.getStatementGroups(), form.getRevisionId());
        }

        @JsonProperty(value="add")
        public String getAddCommand() {
            return "";
        }
    }

    static class RemovedSense {
        @JsonIgnore
        private final SenseIdValue id;

        RemovedSense(SenseIdValue id) {
            this.id = id;
        }

        @JsonProperty
        String getId() {
            return this.id.getId();
        }

        @JsonProperty(value="remove")
        String getRemoveCommand() {
            return "";
        }
    }

    static class AddedSense
    extends SenseDocumentImpl {
        AddedSense(SenseDocument sense) {
            super(SenseIdValue.NULL, new ArrayList<MonolingualTextValue>(sense.getGlosses().values()), sense.getStatementGroups(), sense.getRevisionId());
        }

        @JsonProperty(value="add")
        public String getAddCommand() {
            return "";
        }
    }
}

