/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.implementation.TermedDocumentUpdateImpl;
import org.wikidata.wdtk.datamodel.interfaces.AliasUpdate;
import org.wikidata.wdtk.datamodel.interfaces.ItemIdValue;
import org.wikidata.wdtk.datamodel.interfaces.ItemUpdate;
import org.wikidata.wdtk.datamodel.interfaces.SiteLink;
import org.wikidata.wdtk.datamodel.interfaces.StatementUpdate;
import org.wikidata.wdtk.datamodel.interfaces.TermUpdate;

public class ItemUpdateImpl
extends TermedDocumentUpdateImpl
implements ItemUpdate {
    @JsonIgnore
    private final Map<String, SiteLink> modifiedSiteLinks;
    @JsonIgnore
    private final Set<String> removedSiteLinks;

    public ItemUpdateImpl(ItemIdValue entityId, long revisionId, TermUpdate labels, TermUpdate descriptions, Map<String, AliasUpdate> aliases, StatementUpdate statements, Collection<SiteLink> modifiedSiteLinks, Collection<String> removedSiteLinks) {
        super(entityId, revisionId, labels, descriptions, aliases, statements);
        Objects.requireNonNull(modifiedSiteLinks, "Collection of modified site links cannot be null.");
        Objects.requireNonNull(removedSiteLinks, "Collection of removed site links cannot be null.");
        for (SiteLink link : modifiedSiteLinks) {
            Objects.requireNonNull(link, "Site link cannot be null.");
        }
        for (String siteKey : removedSiteLinks) {
            Validate.notBlank((CharSequence)siteKey, (String)"Site key of removed site link cannot be null or blank.", (Object[])new Object[0]);
        }
        long distinctSiteKeys = Stream.concat(modifiedSiteLinks.stream().map(l -> l.getSiteKey()), removedSiteLinks.stream()).distinct().count();
        Validate.isTrue((distinctSiteKeys == (long)(modifiedSiteLinks.size() + removedSiteLinks.size()) ? 1 : 0) != 0, (String)"Duplicate site key.", (Object[])new Object[0]);
        this.modifiedSiteLinks = Collections.unmodifiableMap(modifiedSiteLinks.stream().collect(Collectors.toMap(sl -> sl.getSiteKey(), sl -> sl)));
        this.removedSiteLinks = Collections.unmodifiableSet(new HashSet<String>(removedSiteLinks));
    }

    @Override
    @JsonIgnore
    public ItemIdValue getEntityId() {
        return (ItemIdValue)super.getEntityId();
    }

    @Override
    @JsonIgnore
    public boolean isEmpty() {
        return super.isEmpty() && this.modifiedSiteLinks.isEmpty() && this.removedSiteLinks.isEmpty();
    }

    @Override
    @JsonIgnore
    public Map<String, SiteLink> getModifiedSiteLinks() {
        return this.modifiedSiteLinks;
    }

    @Override
    @JsonIgnore
    public Set<String> getRemovedSiteLinks() {
        return this.removedSiteLinks;
    }

    @JsonProperty(value="sitelinks")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    Map<String, Object> getJsonSiteLinks() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (SiteLink link : this.modifiedSiteLinks.values()) {
            map.put(link.getSiteKey(), link);
        }
        for (String site : this.removedSiteLinks) {
            map.put(site, new RemovedSiteLink(site));
        }
        return map;
    }

    public boolean equals(Object obj) {
        return Equality.equalsItemUpdate(this, obj);
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    static class RemovedSiteLink {
        private final String site;

        RemovedSiteLink(String site) {
            this.site = site;
        }

        @JsonProperty
        String getSite() {
            return this.site;
        }

        @JsonProperty(value="remove")
        String getRemoveCommand() {
            return "";
        }
    }
}

