/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.helpers.ToString;
import org.wikidata.wdtk.datamodel.implementation.FormIdValueImpl;
import org.wikidata.wdtk.datamodel.implementation.ItemIdValueImpl;
import org.wikidata.wdtk.datamodel.implementation.StatementDocumentImpl;
import org.wikidata.wdtk.datamodel.implementation.StatementImpl;
import org.wikidata.wdtk.datamodel.implementation.TermImpl;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.FormDocument;
import org.wikidata.wdtk.datamodel.interfaces.FormIdValue;
import org.wikidata.wdtk.datamodel.interfaces.ItemIdValue;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementGroup;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
public class FormDocumentImpl
extends StatementDocumentImpl
implements FormDocument {
    private final List<ItemIdValue> grammaticalFeatures;
    private final Map<String, MonolingualTextValue> representations;

    FormDocumentImpl(FormIdValue id, List<MonolingualTextValue> representations, List<ItemIdValue> grammaticalFeatures, List<StatementGroup> statements, long revisionId) {
        super((EntityIdValue)id, statements, revisionId);
        this.representations = representations == null || representations.isEmpty() ? Collections.emptyMap() : FormDocumentImpl.constructTermMap(representations);
        this.grammaticalFeatures = grammaticalFeatures == null ? Collections.emptyList() : grammaticalFeatures;
        this.grammaticalFeatures.sort(Comparator.comparing(EntityIdValue::getId));
    }

    @JsonCreator
    FormDocumentImpl(@JsonProperty(value="id") String jsonId, @JsonProperty(value="representations") @JsonDeserialize(contentAs=TermImpl.class) Map<String, MonolingualTextValue> representations, @JsonProperty(value="grammaticalFeatures") List<String> grammaticalFeatures, @JsonProperty(value="claims") Map<String, List<StatementImpl.PreStatement>> claims, @JsonProperty(value="lastrevid") long revisionId, @JacksonInject(value="siteIri") String siteIri) {
        super(jsonId, claims, revisionId, siteIri);
        this.representations = representations == null ? Collections.emptyMap() : representations;
        this.grammaticalFeatures = grammaticalFeatures == null || grammaticalFeatures.isEmpty() ? Collections.emptyList() : this.constructGrammaticalFeatures(grammaticalFeatures, siteIri);
    }

    private FormDocumentImpl(FormIdValue id, Map<String, MonolingualTextValue> representations, List<ItemIdValue> grammaticalFeatures, Map<String, List<Statement>> statements, long revisionId) {
        super((EntityIdValue)id, statements, revisionId);
        this.representations = representations;
        this.grammaticalFeatures = grammaticalFeatures;
    }

    private static Map<String, MonolingualTextValue> constructTermMap(List<MonolingualTextValue> terms) {
        HashMap<String, MonolingualTextValue> map = new HashMap<String, MonolingualTextValue>();
        for (MonolingualTextValue term : terms) {
            String language = term.getLanguageCode();
            if (map.containsKey(language)) {
                throw new IllegalArgumentException("Multiple terms provided for the same language.");
            }
            map.put(language, FormDocumentImpl.toTerm(term));
        }
        return map;
    }

    private static MonolingualTextValue toTerm(MonolingualTextValue term) {
        return term instanceof TermImpl ? term : new TermImpl(term.getLanguageCode(), term.getText());
    }

    private List<ItemIdValue> constructGrammaticalFeatures(List<String> grammaticalFeatures, String siteIri) {
        ArrayList<ItemIdValue> output = new ArrayList<ItemIdValue>(grammaticalFeatures.size());
        for (String grammaticalFeature : grammaticalFeatures) {
            output.add(new ItemIdValueImpl(grammaticalFeature, siteIri));
        }
        return output;
    }

    @Override
    @JsonIgnore
    public FormIdValue getEntityId() {
        return new FormIdValueImpl(this.entityId, this.siteIri);
    }

    @Override
    @JsonIgnore
    public List<ItemIdValue> getGrammaticalFeatures() {
        return this.grammaticalFeatures;
    }

    @JsonProperty(value="grammaticalFeatures")
    List<String> getJsonGrammaticalFeatures() {
        if (this.grammaticalFeatures.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> output = new ArrayList<String>(this.grammaticalFeatures.size());
        for (ItemIdValue feature : this.grammaticalFeatures) {
            output.add(feature.getId());
        }
        return output;
    }

    @JsonProperty(value="type")
    String getType() {
        return "form";
    }

    @Override
    @JsonProperty(value="representations")
    public Map<String, MonolingualTextValue> getRepresentations() {
        return this.representations;
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    public boolean equals(Object obj) {
        return Equality.equalsFormDocument(this, obj);
    }

    public String toString() {
        return ToString.toString(this);
    }

    @Override
    public FormDocument withEntityId(FormIdValue newEntityId) {
        return new FormDocumentImpl(newEntityId, this.representations, this.grammaticalFeatures, this.claims, this.revisionId);
    }

    @Override
    public FormDocument withRevisionId(long newRevisionId) {
        return new FormDocumentImpl(this.getEntityId(), this.representations, this.grammaticalFeatures, this.claims, newRevisionId);
    }

    @Override
    public FormDocument withRepresentation(MonolingualTextValue representation) {
        HashMap<String, MonolingualTextValue> newRepresentations = new HashMap<String, MonolingualTextValue>(this.representations);
        newRepresentations.put(representation.getLanguageCode(), FormDocumentImpl.toTerm(representation));
        return new FormDocumentImpl(this.getEntityId(), newRepresentations, this.grammaticalFeatures, this.claims, this.revisionId);
    }

    @Override
    public FormDocument withGrammaticalFeature(ItemIdValue grammaticalFeature) {
        if (this.grammaticalFeatures.contains(grammaticalFeature)) {
            return this;
        }
        ArrayList<ItemIdValue> newGrammaticalFeatures = new ArrayList<ItemIdValue>(this.grammaticalFeatures);
        newGrammaticalFeatures.add(grammaticalFeature);
        return new FormDocumentImpl(this.getEntityId(), this.representations, newGrammaticalFeatures, this.claims, this.revisionId);
    }

    @Override
    public FormDocument withStatement(Statement statement) {
        Map<String, List<Statement>> newGroups = FormDocumentImpl.addStatementToGroups(statement, this.claims);
        return new FormDocumentImpl(this.getEntityId(), this.representations, this.grammaticalFeatures, newGroups, this.revisionId);
    }

    @Override
    public FormDocument withoutStatementIds(Set<String> statementIds) {
        Map<String, List<Statement>> newGroups = FormDocumentImpl.removeStatements(statementIds, this.claims);
        return new FormDocumentImpl(this.getEntityId(), this.representations, this.grammaticalFeatures, newGroups, this.revisionId);
    }
}

