/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.implementation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.helpers.Equality;
import org.wikidata.wdtk.datamodel.helpers.Hash;
import org.wikidata.wdtk.datamodel.implementation.TermImpl;
import org.wikidata.wdtk.datamodel.interfaces.AliasUpdate;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;

public class AliasUpdateImpl
implements AliasUpdate {
    @JsonIgnore
    private final String languageCode;
    @JsonIgnore
    private final List<MonolingualTextValue> recreated;
    private final List<MonolingualTextValue> added;
    private final Set<MonolingualTextValue> removed;

    public AliasUpdateImpl(List<MonolingualTextValue> recreated, List<MonolingualTextValue> added, Collection<MonolingualTextValue> removed) {
        Objects.requireNonNull(added, "List of added aliases cannot be null.");
        Objects.requireNonNull(removed, "List of removed aliases cannot be null.");
        Validate.isTrue((recreated == null || added.isEmpty() && removed.isEmpty() ? 1 : 0) != 0, (String)"Cannot combine additions/removals with recreating the alias list.", (Object[])new Object[0]);
        ArrayList<MonolingualTextValue> all = new ArrayList<MonolingualTextValue>();
        if (recreated != null) {
            all.addAll(recreated);
        }
        all.addAll(added);
        all.addAll(removed);
        for (MonolingualTextValue alias : all) {
            Validate.notNull((Object)alias, (String)"Alias object cannot be null.", (Object[])new Object[0]);
        }
        Validate.isTrue((all.stream().map(v -> v.getLanguageCode()).distinct().count() <= 1L ? 1 : 0) != 0, (String)"Inconsistent language codes.", (Object[])new Object[0]);
        if (recreated != null) {
            Validate.isTrue((recreated.stream().distinct().count() == (long)recreated.size() ? 1 : 0) != 0, (String)"Every alias in the new list of aliases must be unique.", (Object[])new Object[0]);
        }
        Validate.isTrue((added.stream().distinct().count() == (long)added.size() ? 1 : 0) != 0, (String)"Every new alias must be unique.", (Object[])new Object[0]);
        Validate.isTrue((removed.stream().distinct().count() == (long)removed.size() ? 1 : 0) != 0, (String)"Every removed alias must be unique.", (Object[])new Object[0]);
        Validate.isTrue((all.stream().distinct().count() == (long)all.size() ? 1 : 0) != 0, (String)"Cannot add and remove the same alias.", (Object[])new Object[0]);
        this.languageCode = all.stream().map(v -> v.getLanguageCode()).findFirst().orElse(null);
        this.recreated = recreated != null ? Collections.unmodifiableList(recreated.stream().map(TermImpl::new).collect(Collectors.toList())) : null;
        this.added = Collections.unmodifiableList(added.stream().map(AddedAlias::new).collect(Collectors.toList()));
        this.removed = Collections.unmodifiableSet(removed.stream().map(RemovedAlias::new).collect(Collectors.toSet()));
    }

    @Override
    @JsonIgnore
    public boolean isEmpty() {
        return this.recreated == null && this.added.isEmpty() && this.removed.isEmpty();
    }

    @Override
    @JsonIgnore
    public Optional<String> getLanguageCode() {
        return Optional.ofNullable(this.languageCode);
    }

    @Override
    @JsonIgnore
    public Optional<List<MonolingualTextValue>> getRecreated() {
        return Optional.ofNullable(this.recreated);
    }

    @Override
    @JsonIgnore
    public List<MonolingualTextValue> getAdded() {
        return this.added;
    }

    @Override
    @JsonIgnore
    public Set<MonolingualTextValue> getRemoved() {
        return this.removed;
    }

    @JsonValue
    List<Object> toJson() {
        ArrayList<Object> items = new ArrayList<Object>();
        if (this.recreated != null) {
            items.addAll(this.recreated);
        }
        items.addAll(this.removed);
        items.addAll(this.added);
        if (items.isEmpty() && this.recreated == null) {
            return null;
        }
        return items;
    }

    public boolean equals(Object obj) {
        return Equality.equalsAliasUpdate(this, obj);
    }

    public int hashCode() {
        return Hash.hashCode(this);
    }

    static class RemovedAlias
    extends TermImpl {
        RemovedAlias(MonolingualTextValue alias) {
            super(alias);
        }

        @JsonProperty(value="remove")
        String getRemoveCommand() {
            return "";
        }
    }

    static class AddedAlias
    extends TermImpl {
        AddedAlias(MonolingualTextValue alias) {
            super(alias);
        }

        @JsonProperty(value="add")
        String getAddCommand() {
            return "";
        }
    }
}

