/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.helpers;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.helpers.AliasUpdateBuilder;
import org.wikidata.wdtk.datamodel.helpers.ItemUpdateBuilder;
import org.wikidata.wdtk.datamodel.helpers.LabeledDocumentUpdateBuilder;
import org.wikidata.wdtk.datamodel.helpers.PropertyUpdateBuilder;
import org.wikidata.wdtk.datamodel.helpers.TermUpdateBuilder;
import org.wikidata.wdtk.datamodel.interfaces.AliasUpdate;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.ItemDocument;
import org.wikidata.wdtk.datamodel.interfaces.ItemIdValue;
import org.wikidata.wdtk.datamodel.interfaces.PropertyDocument;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.StatementUpdate;
import org.wikidata.wdtk.datamodel.interfaces.TermUpdate;
import org.wikidata.wdtk.datamodel.interfaces.TermedStatementDocument;
import org.wikidata.wdtk.datamodel.interfaces.TermedStatementDocumentUpdate;

public abstract class TermedDocumentUpdateBuilder
extends LabeledDocumentUpdateBuilder {
    TermUpdate descriptions = TermUpdate.EMPTY;
    final Map<String, AliasUpdate> aliases = new HashMap<String, AliasUpdate>();

    protected TermedDocumentUpdateBuilder(EntityIdValue entityId, long revisionId) {
        super(entityId, revisionId);
    }

    protected TermedDocumentUpdateBuilder(TermedStatementDocument revision) {
        super(revision);
    }

    public static TermedDocumentUpdateBuilder forBaseRevisionId(EntityIdValue entityId, long revisionId) {
        Objects.requireNonNull(entityId, "Entity ID cannot be null.");
        if (entityId instanceof ItemIdValue) {
            return ItemUpdateBuilder.forBaseRevisionId((ItemIdValue)entityId, revisionId);
        }
        if (entityId instanceof PropertyIdValue) {
            return PropertyUpdateBuilder.forBaseRevisionId((PropertyIdValue)entityId, revisionId);
        }
        throw new IllegalArgumentException("Unrecognized entity ID type.");
    }

    public static TermedDocumentUpdateBuilder forEntityId(EntityIdValue entityId) {
        return TermedDocumentUpdateBuilder.forBaseRevisionId(entityId, 0L);
    }

    public static TermedDocumentUpdateBuilder forBaseRevision(TermedStatementDocument revision) {
        Objects.requireNonNull(revision, "Base entity revision cannot be null.");
        if (revision instanceof ItemDocument) {
            return ItemUpdateBuilder.forBaseRevision((ItemDocument)revision);
        }
        if (revision instanceof PropertyDocument) {
            return PropertyUpdateBuilder.forBaseRevision((PropertyDocument)revision);
        }
        throw new IllegalArgumentException("Unrecognized entity document type.");
    }

    @Override
    TermedStatementDocument getBaseRevision() {
        return (TermedStatementDocument)super.getBaseRevision();
    }

    @Override
    public TermedDocumentUpdateBuilder updateStatements(StatementUpdate update) {
        super.updateStatements(update);
        return this;
    }

    @Override
    public TermedDocumentUpdateBuilder updateLabels(TermUpdate update) {
        super.updateLabels(update);
        return this;
    }

    public TermedDocumentUpdateBuilder updateDescriptions(TermUpdate update) {
        Objects.requireNonNull(update, "Update cannot be null.");
        TermUpdateBuilder combined = this.getBaseRevision() != null ? TermUpdateBuilder.forTerms(this.getBaseRevision().getDescriptions().values()) : TermUpdateBuilder.create();
        combined.append(this.descriptions);
        combined.append(update);
        this.descriptions = combined.build();
        return this;
    }

    public TermedDocumentUpdateBuilder updateAliases(String language, AliasUpdate update) {
        Validate.notBlank((CharSequence)language, (String)"Specify language code.", (Object[])new Object[0]);
        Objects.requireNonNull(update, "Alias update cannot be null.");
        if (update.getLanguageCode().isPresent()) {
            Validate.isTrue((boolean)language.equals(update.getLanguageCode().get()), (String)"Alias update must have matching language code.", (Object[])new Object[0]);
        }
        AliasUpdateBuilder builder = this.getBaseRevision() != null ? AliasUpdateBuilder.forAliases(this.getBaseRevision().getAliases().getOrDefault(language, Collections.emptyList())) : AliasUpdateBuilder.create();
        builder.append(this.aliases.getOrDefault(language, AliasUpdate.EMPTY));
        builder.append(update);
        AliasUpdate combined = builder.build();
        if (!combined.isEmpty()) {
            this.aliases.put(language, combined);
        } else {
            this.aliases.remove(language);
        }
        return this;
    }

    void append(TermedStatementDocumentUpdate update) {
        super.append(update);
        this.updateDescriptions(update.getDescriptions());
        for (Map.Entry<String, AliasUpdate> entry : update.getAliases().entrySet()) {
            this.updateAliases(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public abstract TermedStatementDocumentUpdate build();
}

