/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.helpers;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.wikidata.wdtk.datamodel.helpers.Datamodel;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.TermUpdate;

public class TermUpdateBuilder {
    private final Map<String, MonolingualTextValue> base;
    private final Map<String, MonolingualTextValue> modified = new HashMap<String, MonolingualTextValue>();
    private final Set<String> removed = new HashSet<String>();

    private TermUpdateBuilder(Collection<MonolingualTextValue> base) {
        if (base != null) {
            for (MonolingualTextValue value : base) {
                Objects.requireNonNull(value, "Base document terms cannot be null.");
            }
            Validate.isTrue((base.stream().map(v -> v.getLanguageCode()).distinct().count() == (long)base.size() ? 1 : 0) != 0, (String)"Base document terms must have unique language codes.", (Object[])new Object[0]);
            this.base = base.stream().collect(Collectors.toMap(v -> v.getLanguageCode(), v -> v));
        } else {
            this.base = null;
        }
    }

    public static TermUpdateBuilder create() {
        return new TermUpdateBuilder(null);
    }

    public static TermUpdateBuilder forTerms(Collection<MonolingualTextValue> terms) {
        Objects.requireNonNull(terms, "Base document term collection cannot be null.");
        return new TermUpdateBuilder(terms);
    }

    public TermUpdateBuilder put(MonolingualTextValue term) {
        Objects.requireNonNull(term, "Term cannot be null.");
        if (this.base != null && term.equals(this.base.get(term.getLanguageCode()))) {
            this.modified.remove(term.getLanguageCode());
            this.removed.remove(term.getLanguageCode());
            return this;
        }
        this.modified.put(term.getLanguageCode(), term);
        this.removed.remove(term.getLanguageCode());
        return this;
    }

    public TermUpdateBuilder remove(String languageCode) {
        Validate.notBlank((CharSequence)languageCode, (String)"Language code must be provided.", (Object[])new Object[0]);
        if (this.base != null && !this.base.containsKey(languageCode)) {
            this.modified.remove(languageCode);
            return this;
        }
        this.removed.add(languageCode);
        this.modified.remove(languageCode);
        return this;
    }

    public TermUpdateBuilder append(TermUpdate update) {
        Objects.requireNonNull(update, "Term update cannot be null.");
        for (MonolingualTextValue term : update.getModified().values()) {
            this.put(term);
        }
        for (String language : update.getRemoved()) {
            this.remove(language);
        }
        return this;
    }

    public TermUpdate build() {
        return Datamodel.makeTermUpdate(this.modified.values(), this.removed);
    }
}

