/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.datamodel.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.datamodel.interfaces.Claim;
import org.wikidata.wdtk.datamodel.interfaces.DataObjectFactory;
import org.wikidata.wdtk.datamodel.interfaces.DatatypeIdValue;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.FormDocument;
import org.wikidata.wdtk.datamodel.interfaces.FormIdValue;
import org.wikidata.wdtk.datamodel.interfaces.GlobeCoordinatesValue;
import org.wikidata.wdtk.datamodel.interfaces.ItemDocument;
import org.wikidata.wdtk.datamodel.interfaces.ItemIdValue;
import org.wikidata.wdtk.datamodel.interfaces.LexemeDocument;
import org.wikidata.wdtk.datamodel.interfaces.LexemeIdValue;
import org.wikidata.wdtk.datamodel.interfaces.MediaInfoDocument;
import org.wikidata.wdtk.datamodel.interfaces.MediaInfoIdValue;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.NoValueSnak;
import org.wikidata.wdtk.datamodel.interfaces.PropertyDocument;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.QuantityValue;
import org.wikidata.wdtk.datamodel.interfaces.Reference;
import org.wikidata.wdtk.datamodel.interfaces.SenseDocument;
import org.wikidata.wdtk.datamodel.interfaces.SenseIdValue;
import org.wikidata.wdtk.datamodel.interfaces.SiteLink;
import org.wikidata.wdtk.datamodel.interfaces.Snak;
import org.wikidata.wdtk.datamodel.interfaces.SnakGroup;
import org.wikidata.wdtk.datamodel.interfaces.SnakVisitor;
import org.wikidata.wdtk.datamodel.interfaces.SomeValueSnak;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementGroup;
import org.wikidata.wdtk.datamodel.interfaces.StringValue;
import org.wikidata.wdtk.datamodel.interfaces.TimeValue;
import org.wikidata.wdtk.datamodel.interfaces.UnsupportedValue;
import org.wikidata.wdtk.datamodel.interfaces.Value;
import org.wikidata.wdtk.datamodel.interfaces.ValueSnak;
import org.wikidata.wdtk.datamodel.interfaces.ValueVisitor;

public class DatamodelConverter
implements SnakVisitor<Snak>,
ValueVisitor<Value> {
    static final Logger logger = LoggerFactory.getLogger(DatamodelConverter.class);
    private final DataObjectFactory dataObjectFactory;

    public DatamodelConverter(DataObjectFactory dataObjectFactory) {
        this.dataObjectFactory = dataObjectFactory;
    }

    public ItemIdValue copy(ItemIdValue object) {
        return this.dataObjectFactory.getItemIdValue(object.getId(), object.getSiteIri());
    }

    public PropertyIdValue copy(PropertyIdValue object) {
        return this.dataObjectFactory.getPropertyIdValue(object.getId(), object.getSiteIri());
    }

    public LexemeIdValue copy(LexemeIdValue object) {
        return this.dataObjectFactory.getLexemeIdValue(object.getId(), object.getSiteIri());
    }

    public FormIdValue copy(FormIdValue object) {
        return this.dataObjectFactory.getFormIdValue(object.getId(), object.getSiteIri());
    }

    public SenseIdValue copy(SenseIdValue object) {
        return this.dataObjectFactory.getSenseIdValue(object.getId(), object.getSiteIri());
    }

    public MediaInfoIdValue copy(MediaInfoIdValue object) {
        return this.dataObjectFactory.getMediaInfoIdValue(object.getId(), object.getSiteIri());
    }

    public DatatypeIdValue copy(DatatypeIdValue object) {
        return this.dataObjectFactory.getDatatypeIdValueFromJsonId(object.getJsonString());
    }

    public TimeValue copy(TimeValue object) {
        return this.dataObjectFactory.getTimeValue(object.getYear(), object.getMonth(), object.getDay(), object.getHour(), object.getMinute(), object.getSecond(), object.getPrecision(), object.getBeforeTolerance(), object.getAfterTolerance(), object.getTimezoneOffset(), object.getPreferredCalendarModel());
    }

    public GlobeCoordinatesValue copy(GlobeCoordinatesValue object) {
        return this.dataObjectFactory.getGlobeCoordinatesValue(object.getLatitude(), object.getLongitude(), object.getPrecision(), object.getGlobe());
    }

    public StringValue copy(StringValue object) {
        return this.dataObjectFactory.getStringValue(object.getString());
    }

    public MonolingualTextValue copy(MonolingualTextValue object) {
        return this.dataObjectFactory.getMonolingualTextValue(object.getText(), object.getLanguageCode());
    }

    public QuantityValue copy(QuantityValue object) {
        return this.dataObjectFactory.getQuantityValue(object.getNumericValue(), object.getLowerBound(), object.getUpperBound(), object.getUnitItemId());
    }

    public UnsupportedValue copy(UnsupportedValue object) {
        return object;
    }

    private Snak copy(Snak snak) {
        if (snak instanceof ValueSnak) {
            return this.copy((ValueSnak)snak);
        }
        if (snak instanceof NoValueSnak) {
            return this.copy((NoValueSnak)snak);
        }
        if (snak instanceof SomeValueSnak) {
            return this.copy((SomeValueSnak)snak);
        }
        throw new IllegalArgumentException("I don't know how to copy snaks of type " + snak.getClass());
    }

    public ValueSnak copy(ValueSnak object) {
        return this.dataObjectFactory.getValueSnak(this.copy(object.getPropertyId()), this.copyValue(object.getValue()));
    }

    public SomeValueSnak copy(SomeValueSnak object) {
        return this.dataObjectFactory.getSomeValueSnak(this.copy(object.getPropertyId()));
    }

    public NoValueSnak copy(NoValueSnak object) {
        return this.dataObjectFactory.getNoValueSnak(this.copy(object.getPropertyId()));
    }

    public SnakGroup copy(SnakGroup object) {
        ArrayList<Snak> snaks = new ArrayList<Snak>(object.size());
        for (Snak snak : object) {
            snaks.add(this.copy(snak));
        }
        return this.dataObjectFactory.getSnakGroup(snaks);
    }

    public Claim copy(Claim object) {
        return this.dataObjectFactory.getClaim((EntityIdValue)this.visit(object.getSubject()), this.copy(object.getMainSnak()), this.copy(object.getQualifiers()));
    }

    public Reference copy(Reference object) {
        return this.dataObjectFactory.getReference(this.copy(object.getSnakGroups()));
    }

    public Statement copy(Statement object) {
        return this.dataObjectFactory.getStatement((EntityIdValue)this.visit(object.getSubject()), this.copy(object.getMainSnak()), this.copy(object.getQualifiers()), this.copyReferences(object.getReferences()), object.getRank(), object.getStatementId());
    }

    public StatementGroup copy(StatementGroup object) {
        ArrayList<Statement> statements = new ArrayList<Statement>(object.getStatements().size());
        for (Statement statement : object.getStatements()) {
            statements.add(this.copy(statement));
        }
        return this.dataObjectFactory.getStatementGroup(statements);
    }

    public SiteLink copy(SiteLink object) {
        return this.dataObjectFactory.getSiteLink(object.getPageTitle(), object.getSiteKey(), object.getBadges());
    }

    public PropertyDocument copy(PropertyDocument object) {
        return this.dataObjectFactory.getPropertyDocument(this.copy(object.getEntityId()), this.copyMonoLingualTextValues(object.getLabels().values()), this.copyMonoLingualTextValues(object.getDescriptions().values()), this.copyAliasMap(object.getAliases()), this.copyStatementGroups(object.getStatementGroups()), this.copy(object.getDatatype()), object.getRevisionId());
    }

    public ItemDocument copy(ItemDocument object) {
        return this.dataObjectFactory.getItemDocument(this.copy(object.getEntityId()), this.copyMonoLingualTextValues(object.getLabels().values()), this.copyMonoLingualTextValues(object.getDescriptions().values()), this.copyAliasMap(object.getAliases()), this.copyStatementGroups(object.getStatementGroups()), this.copySiteLinks(object.getSiteLinks()), object.getRevisionId());
    }

    public MediaInfoDocument copy(MediaInfoDocument object) {
        return this.dataObjectFactory.getMediaInfoDocument(this.copy(object.getEntityId()), this.copyMonoLingualTextValues(object.getLabels().values()), this.copyStatementGroups(object.getStatementGroups()), object.getRevisionId());
    }

    public LexemeDocument copy(LexemeDocument object) {
        return this.dataObjectFactory.getLexemeDocument(this.copy(object.getEntityId()), this.copy(object.getLexicalCategory()), this.copy(object.getLanguage()), this.copyMonoLingualTextValues(object.getLemmas().values()), this.copyStatementGroups(object.getStatementGroups()), this.copyFormDocuments(object.getForms()), this.copySenseDocuments(object.getSenses()), object.getRevisionId());
    }

    public FormDocument copy(FormDocument object) {
        return this.dataObjectFactory.getFormDocument(this.copy(object.getEntityId()), this.copyMonoLingualTextValues(object.getRepresentations().values()), this.copyItemIds(object.getGrammaticalFeatures()), this.copyStatementGroups(object.getStatementGroups()), object.getRevisionId());
    }

    public SenseDocument copy(SenseDocument object) {
        return this.dataObjectFactory.getSenseDocument(this.copy(object.getEntityId()), this.copyMonoLingualTextValues(object.getGlosses().values()), this.copyStatementGroups(object.getStatementGroups()), object.getRevisionId());
    }

    public Snak copySnak(Snak snak) {
        return snak.accept(this);
    }

    @Override
    public Snak visit(ValueSnak snak) {
        return this.copy(snak);
    }

    @Override
    public Snak visit(SomeValueSnak snak) {
        return this.copy(snak);
    }

    @Override
    public Snak visit(NoValueSnak snak) {
        return this.copy(snak);
    }

    public Value copyValue(Value value) {
        return value.accept(this);
    }

    @Override
    public Value visit(EntityIdValue value) {
        if (value instanceof ItemIdValue) {
            return this.copy((ItemIdValue)value);
        }
        if (value instanceof PropertyIdValue) {
            return this.copy((PropertyIdValue)value);
        }
        if (value instanceof LexemeIdValue) {
            return this.copy((LexemeIdValue)value);
        }
        if (value instanceof FormIdValue) {
            return this.copy((FormIdValue)value);
        }
        if (value instanceof SenseIdValue) {
            return this.copy((SenseIdValue)value);
        }
        if (value instanceof MediaInfoIdValue) {
            return this.copy((MediaInfoIdValue)value);
        }
        throw new UnsupportedOperationException("Cannot convert entity id value: " + value.getClass());
    }

    @Override
    public Value visit(GlobeCoordinatesValue value) {
        return this.copy(value);
    }

    @Override
    public Value visit(MonolingualTextValue value) {
        return this.copy(value);
    }

    @Override
    public Value visit(QuantityValue value) {
        return this.copy(value);
    }

    @Override
    public Value visit(StringValue value) {
        return this.copy(value);
    }

    @Override
    public Value visit(TimeValue value) {
        return this.copy(value);
    }

    @Override
    public Value visit(UnsupportedValue value) {
        return this.copy(value);
    }

    private List<MonolingualTextValue> copyAliasMap(Map<String, List<MonolingualTextValue>> aliasMap) {
        ArrayList<MonolingualTextValue> aliases = new ArrayList<MonolingualTextValue>();
        for (Map.Entry<String, List<MonolingualTextValue>> langAliases : aliasMap.entrySet()) {
            for (MonolingualTextValue mtv : langAliases.getValue()) {
                aliases.add(this.copy(mtv));
            }
        }
        return aliases;
    }

    private List<SnakGroup> copy(List<SnakGroup> snakGroups) {
        ArrayList<SnakGroup> result = new ArrayList<SnakGroup>(snakGroups.size());
        for (SnakGroup snakGroup : snakGroups) {
            result.add(this.copy(snakGroup));
        }
        return result;
    }

    private List<Reference> copyReferences(List<Reference> references) {
        ArrayList<Reference> result = new ArrayList<Reference>(references.size());
        for (Reference reference : references) {
            result.add(this.dataObjectFactory.getReference(this.copy(reference.getSnakGroups())));
        }
        return result;
    }

    private List<StatementGroup> copyStatementGroups(List<StatementGroup> statementGroups) {
        ArrayList<StatementGroup> result = new ArrayList<StatementGroup>(statementGroups.size());
        for (StatementGroup statementGroup : statementGroups) {
            result.add(this.copy(statementGroup));
        }
        return result;
    }

    private List<MonolingualTextValue> copyMonoLingualTextValues(Collection<MonolingualTextValue> monoLingualTextValues) {
        ArrayList<MonolingualTextValue> result = new ArrayList<MonolingualTextValue>(monoLingualTextValues.size());
        for (MonolingualTextValue mtv : monoLingualTextValues) {
            result.add(this.copy(mtv));
        }
        return result;
    }

    private Map<String, SiteLink> copySiteLinks(Map<String, SiteLink> siteLinks) {
        HashMap<String, SiteLink> result = new HashMap<String, SiteLink>(siteLinks.size());
        for (Map.Entry<String, SiteLink> entry : siteLinks.entrySet()) {
            result.put(entry.getKey(), this.copy(entry.getValue()));
        }
        return result;
    }

    private List<ItemIdValue> copyItemIds(List<ItemIdValue> ids) {
        return ids.stream().map(id -> this.copy((ItemIdValue)id)).collect(Collectors.toList());
    }

    private List<SenseDocument> copySenseDocuments(List<SenseDocument> senses) {
        return senses.stream().map(sense -> this.copy((SenseDocument)sense)).collect(Collectors.toList());
    }

    private List<FormDocument> copyFormDocuments(List<FormDocument> forms) {
        return forms.stream().map(form -> this.copy((FormDocument)form)).collect(Collectors.toList());
    }
}

