/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.codesource;

import java.util.LinkedHashMap;
import org.wikbook.codesource.CodeSource;
import org.wikbook.codesource.MemberKey;
import org.wikbook.codesource.MemberSource;
import org.wikbook.codesource.NamedMemberSource;
import org.wikbook.codesource.Signature;
import org.wikbook.codesource.SignedMemberSource;
import org.wikbook.text.Clip;
import org.wikbook.text.TextArea;

public class TypeSource
extends CodeSource {
    final TextArea source;
    private final String name;
    private final LinkedHashMap<MemberKey, SignedMemberSource> methods;
    private final LinkedHashMap<String, NamedMemberSource> fields;

    TypeSource(TextArea source, String name, Clip clip, String javaDoc) {
        super(clip, javaDoc);
        this.source = source;
        this.name = name;
        this.methods = new LinkedHashMap();
        this.fields = new LinkedHashMap();
    }

    void addMember(MemberSource member) {
        if (member instanceof SignedMemberSource) {
            SignedMemberSource signedMember = (SignedMemberSource)member;
            if (signedMember.type != null) {
                throw new IllegalArgumentException();
            }
            this.methods.put(signedMember.key, signedMember);
            signedMember.type = this;
        } else if (member instanceof NamedMemberSource) {
            NamedMemberSource namedMember = (NamedMemberSource)member;
            if (namedMember.type != null) {
                throw new IllegalArgumentException();
            }
            this.fields.put(namedMember.name, namedMember);
            namedMember.type = this;
        } else {
            throw new IllegalArgumentException("Not accepted " + member);
        }
    }

    public String getName() {
        return this.name;
    }

    protected TypeSource getType() {
        return this;
    }

    public MemberSource findMember(String member) {
        if (member == null) {
            throw new NullPointerException();
        }
        MemberKey key = MemberKey.parse(member);
        if (key.signature == null) {
            NamedMemberSource field = this.fields.get(key.name);
            if (field != null) {
                return field;
            }
            key = new MemberKey(key.name, new Signature(new String[0]));
        }
        return this.methods.get(key);
    }

    public String toString() {
        return "TypeSource[fqn=" + this.name + "]";
    }
}

