/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.codesource;

import japa.parser.JavaParser;
import japa.parser.ParseException;
import japa.parser.ast.CompilationUnit;
import japa.parser.ast.Node;
import japa.parser.ast.PackageDeclaration;
import japa.parser.ast.body.BodyDeclaration;
import japa.parser.ast.body.ClassOrInterfaceDeclaration;
import japa.parser.ast.body.ConstructorDeclaration;
import japa.parser.ast.body.EnumDeclaration;
import japa.parser.ast.body.FieldDeclaration;
import japa.parser.ast.body.JavadocComment;
import japa.parser.ast.body.MethodDeclaration;
import japa.parser.ast.body.VariableDeclarator;
import japa.parser.ast.body.VariableDeclaratorId;
import japa.parser.ast.expr.NameExpr;
import japa.parser.ast.expr.QualifiedNameExpr;
import japa.parser.ast.visitor.GenericVisitor;
import japa.parser.ast.visitor.GenericVisitorAdapter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.cojen.classfile.ClassFile;
import org.cojen.classfile.MethodDesc;
import org.cojen.classfile.MethodInfo;
import org.cojen.classfile.TypeDesc;
import org.wikbook.codesource.BodySource;
import org.wikbook.codesource.CodeSourceBuilder;
import org.wikbook.codesource.CodeSourceException;
import org.wikbook.codesource.FieldSource;
import org.wikbook.codesource.MemberKey;
import org.wikbook.codesource.MethodSource;
import org.wikbook.codesource.Signature;
import org.wikbook.codesource.TypeSource;
import org.wikbook.text.Clip;
import org.wikbook.text.Position;
import org.wikbook.text.TextArea;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CompilationUnitVisitor
extends GenericVisitorAdapter<Void, Visit> {
    private final CodeSourceBuilder builder;

    CompilationUnitVisitor(CodeSourceBuilder builder) {
        this.builder = builder;
    }

    Visit visit(String compilationUnitPath) throws IOException, ParseException, CodeSourceException {
        InputStream cuis = this.builder.context.getResource(compilationUnitPath);
        if (cuis == null) {
            throw new CodeSourceException("Compilation path cannot be located " + compilationUnitPath);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[20];
        int l = cuis.read(buffer);
        while (l != -1) {
            baos.write(buffer, 0, l);
            l = cuis.read(buffer);
        }
        String s = baos.toString();
        Visit visit = new Visit(s);
        visit.accept(this);
        return visit;
    }

    private String toString(NameExpr n) {
        if (n instanceof QualifiedNameExpr) {
            QualifiedNameExpr qn = (QualifiedNameExpr)n;
            return qn.getQualifier() + "." + qn.getName();
        }
        return n.getName();
    }

    public Void visit(PackageDeclaration n, Visit arg) {
        arg.pkg = this.toString(n.getName());
        return (Void)super.visit(n, (Object)arg);
    }

    public Void visit(ClassOrInterfaceDeclaration n, Visit v) {
        String fqn = (v.pkg == null || v.pkg.length() == 0 ? "" : v.pkg + ".") + n.getName();
        InputStream in = this.builder.context.getResource(fqn.replace(".", "/") + ".class");
        if (in == null) {
            throw new CodeSourceException("Cannot locate class file for fqn " + fqn);
        }
        try {
            ClassFile cf = ClassFile.readFrom((InputStream)in);
            ArrayList<Signature> constructorSignatures = new ArrayList<Signature>();
            for (MethodInfo mi : cf.getConstructors()) {
                MethodDesc desc = mi.getMethodDescriptor();
                ArrayList<String> parameterTypes = new ArrayList<String>();
                for (TypeDesc typeDesc : desc.getParameterTypes()) {
                    parameterTypes.add(typeDesc.getFullName());
                }
                constructorSignatures.add(new Signature(parameterTypes));
            }
            ArrayList<Signature> methodSignatures = new ArrayList<Signature>();
            for (MethodInfo mi : cf.getMethods()) {
                MethodDesc desc = mi.getMethodDescriptor();
                ArrayList<String> parameterTypes = new ArrayList<String>();
                for (TypeDesc typeDesc : desc.getParameterTypes()) {
                    parameterTypes.add(typeDesc.getFullName());
                }
                methodSignatures.add(new Signature(parameterTypes));
            }
            v.constructorSignatures = constructorSignatures.iterator();
            v.methodSignatures = methodSignatures.iterator();
        }
        catch (IOException e) {
            throw new CodeSourceException("Could not load class " + fqn, e);
        }
        v.stack.addLast(new LinkedList());
        Void ret = (Void)super.visit(n, (Object)v);
        List blah = v.stack.removeLast();
        Clip typeClip = Clip.get(n.getBeginLine() - 1, 0, n.getEndLine() - 1, n.getEndColumn());
        TypeSource typeSource = new TypeSource(new TextArea(v.source), fqn, typeClip, v.javaDoc((BodyDeclaration)n));
        for (BodySource bodySource : blah) {
            if (bodySource instanceof MethodSource) {
                MethodSource methodSource = (MethodSource)bodySource;
                typeSource.addMethod(methodSource);
                continue;
            }
            if (!(bodySource instanceof FieldSource)) continue;
            FieldSource fieldSource = (FieldSource)bodySource;
            typeSource.addField(fieldSource);
        }
        v.types.add(typeSource);
        return ret;
    }

    public Void visit(EnumDeclaration n, Visit v) {
        return (Void)super.visit(n, (Object)v);
    }

    public Void visit(FieldDeclaration n, Visit v) {
        if (n.getVariables().size() != 1) {
            throw new UnsupportedOperationException("todo");
        }
        VariableDeclarator declarator = (VariableDeclarator)n.getVariables().get(0);
        VariableDeclaratorId id = declarator.getId();
        FieldSource fieldSource = new FieldSource(id.getName(), Clip.get(n.getBeginLine() - 1, 0, n.getEndLine() - 1, n.getEndColumn()), v.javaDoc((BodyDeclaration)n));
        v.stack.getLast().addLast(fieldSource);
        return (Void)super.visit(n, (Object)v);
    }

    public Void visit(MethodDeclaration n, Visit v) {
        Signature signature = v.methodSignatures.next();
        MethodSource methodSource = new MethodSource(new MemberKey(n.getName(), signature), Clip.get(n.getBeginLine() - 1, 0, n.getEndLine() - 1, n.getEndColumn()), v.javaDoc((BodyDeclaration)n));
        v.stack.getLast().addLast(methodSource);
        return (Void)super.visit(n, (Object)v);
    }

    public Void visit(ConstructorDeclaration n, Visit v) {
        Signature signature = v.constructorSignatures.next();
        MethodSource methodSource = new MethodSource(new MemberKey(n.getName(), signature), Clip.get(n.getBeginLine() - 1, 0, n.getEndLine() - 1, n.getEndColumn()), v.javaDoc((BodyDeclaration)n));
        v.stack.getLast().addLast(methodSource);
        return (Void)super.visit(n, (Object)v);
    }

    static class Visit {
        private final CompilationUnit compilationUnit;
        final LinkedList<LinkedList<BodySource>> stack = new LinkedList();
        String pkg;
        Iterator<Signature> constructorSignatures;
        Iterator<Signature> methodSignatures;
        final List<TypeSource> types = new ArrayList<TypeSource>();
        private String source;
        private final TextArea sb;

        private Visit(String source) throws ParseException {
            this.compilationUnit = JavaParser.parse((InputStream)new ByteArrayInputStream(source.getBytes()));
            this.source = source;
            this.sb = new TextArea(source);
        }

        private String clip(Node node) {
            int from = this.sb.offset(Position.get(node.getBeginLine() - 1, 0));
            int to = this.sb.offset(Position.get(node.getEndLine() - 1, node.getEndColumn()));
            return this.source.substring(from, to);
        }

        private String javaDoc(BodyDeclaration node) {
            JavadocComment doc = node.getJavaDoc();
            return doc != null ? this.clip((Node)doc) : null;
        }

        private void accept(CompilationUnitVisitor visitor) {
            this.compilationUnit.accept((GenericVisitor)visitor, (Object)this);
        }
    }
}

