/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.flot;

import java.io.Serializable;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Color
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(Color.class);
    public static final Color BLACK = new Color(0.0, 0.0, 0.0);
    public static final Color WHITE = new Color(1.0, 1.0, 1.0);
    public static final Color BLUE = new Color(0.0, 0.0, 1.0);
    public static final Color GREEN = new Color(0.0, 1.0, 0.0);
    public static final Color RED = new Color(1.0, 0.0, 0.0);
    private float r;
    private float b;
    private float g;

    public Color(int r, int g, int b) {
        if (r < 0 || g < 0 || b < 0 || r > 255 || g > 255 || b > 255) {
            throw new IllegalArgumentException("Arguments have to be between 0 (inclusive) and 256 (exclusive)");
        }
        this.r = (float)((double)r / 255.0);
        this.g = (float)((double)g / 255.0);
        this.b = (float)((double)b / 255.0);
    }

    public Color(double r, double g, double b) {
        if (r < 0.0 || g < 0.0 || b < 0.0 || r > 1.0 || g > 1.0 || b > 1.0) {
            throw new IllegalArgumentException("Arguments have to be between 0 (inclusive) and 1.0 (inclusive)");
        }
        this.r = (float)r;
        this.g = (float)g;
        this.b = (float)b;
    }

    public float red() {
        return this.r;
    }

    public float green() {
        return this.g;
    }

    public float blue() {
        return this.b;
    }

    public String html() {
        return String.format("#%02X%02X%02X", (int)((double)this.r * 255.0), (int)((double)this.g * 255.0), (int)((double)this.b * 255.0));
    }

    public String toString() {
        return String.format("rgb(%.1f, %.1f, %.1f), html(%s)", Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b), this.html());
    }

    public static Color random() {
        Random random = new Random();
        Color color = new Color(random.nextInt(256), random.nextInt(256), random.nextInt(256));
        return color;
    }

    private static float limit(float min, float max, float value) {
        return (float)Math.max(0.0, (double)Math.min(max, value));
    }

    public Color scale(float fr, float fg, float fb) {
        float r = Color.limit(0.0f, 1.0f, this.r * fr);
        float g = Color.limit(0.0f, 1.0f, this.g * fg);
        float b = Color.limit(0.0f, 1.0f, this.b * fb);
        return new Color(r, g, b);
    }
}

