/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.flot;

import org.wicketstuff.flot.Color;
import org.wicketstuff.flot.GraphType;

public class BarGraphType
extends GraphType {
    private static final long serialVersionUID = 1L;
    private Double barWidth;
    private Align align;

    public BarGraphType(Double lineWidth, Boolean fill, Color fillColor, Double barWidth, Align align) {
        super(lineWidth, fill, fillColor);
        this.barWidth = barWidth;
        this.align = align;
    }

    @Override
    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("bars: {");
        String superStr = super.toString();
        if (this.barWidth != null) {
            str.append("barWidth: ");
            str.append(this.barWidth);
            if (this.align != null || superStr.length() > 0) {
                str.append(", ");
            }
        }
        if (this.align != null) {
            str.append("align: ");
            switch (this.align) {
                case LEFT: {
                    str.append("\"left\"");
                    break;
                }
                case CENTER: {
                    str.append("\"center\"");
                }
            }
            if (superStr.length() > 0) {
                str.append(", ");
            }
        }
        str.append(superStr);
        str.append("}");
        return str.toString();
    }

    public static enum Align {
        LEFT,
        CENTER;

    }
}

