/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.validation.validator;

import java.io.Serializable;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;

public abstract class AbstractRangeValidator<R extends Comparable<R> & Serializable, V extends Serializable>
extends Behavior
implements IValidator<V> {
    private static final long serialVersionUID = 1L;
    private R minimum;
    private R maximum;

    public AbstractRangeValidator(R minimum, R maximum) {
        this.setRange(minimum, maximum);
    }

    protected AbstractRangeValidator() {
    }

    protected final void setRange(R minimum, R maximum) {
        if (minimum == null && maximum == null) {
            throw new IllegalArgumentException("Both minimum and maximum values cannot be null");
        }
        this.minimum = minimum;
        this.maximum = maximum;
    }

    @Override
    public void validate(IValidatable<V> validatable) {
        R value = this.getValue(validatable);
        R min = this.getMinimum();
        R max = this.getMaximum();
        if (min != null && value.compareTo(min) < 0 || max != null && value.compareTo(max) > 0) {
            ValidationError error = new ValidationError(this, this.getMode().getVariation());
            error.setVariable("minimum", min);
            error.setVariable("maximum", max);
            validatable.error(this.decorate(error, validatable));
        }
    }

    protected abstract R getValue(IValidatable<V> var1);

    public R getMinimum() {
        return this.minimum;
    }

    public R getMaximum() {
        return this.maximum;
    }

    protected ValidationError decorate(ValidationError error, IValidatable<V> validatable) {
        return error;
    }

    public final Mode getMode() {
        R min = this.getMinimum();
        R max = this.getMaximum();
        if (min == null && max != null) {
            return Mode.MAXIMUM;
        }
        if (max == null && min != null) {
            return Mode.MINIMUM;
        }
        if (max.equals(min)) {
            return Mode.EXACT;
        }
        return Mode.RANGE;
    }

    public static enum Mode {
        MINIMUM,
        MAXIMUM,
        RANGE,
        EXACT;


        public String getVariation() {
            return this.name().toLowerCase();
        }
    }
}

