/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.resource.bundles;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.markup.head.IReferenceHeaderItem;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.PackageResource;
import org.apache.wicket.request.resource.caching.IStaticCacheableResource;
import org.apache.wicket.util.io.ByteArrayOutputStream;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.resource.AbstractResourceStream;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcatBundleResource
extends AbstractResource
implements IStaticCacheableResource {
    private static final Logger log = LoggerFactory.getLogger(ConcatBundleResource.class);
    private static final long serialVersionUID = 1L;
    private List<? extends IReferenceHeaderItem> providedResources;

    public ConcatBundleResource(List<? extends IReferenceHeaderItem> providedResources) {
        this.providedResources = Args.notNull(providedResources, "providedResources");
    }

    @Override
    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        AbstractResource.ResourceResponse resourceResponse = new AbstractResource.ResourceResponse();
        if (resourceResponse.dataNeedsToBeWritten(attributes)) {
            try {
                List<IResourceStream> resources = this.collectResourceStreams();
                if (resources == null) {
                    return this.sendResourceError(resourceResponse, 404, "Unable to find resource");
                }
                resourceResponse.setContentType(this.findContentType(resources));
                Time lastModified = this.findLastModified(resources);
                if (lastModified != null) {
                    resourceResponse.setLastModified(lastModified);
                }
                final byte[] bytes = this.readAllResources(resources);
                resourceResponse.setContentLength(bytes.length);
                resourceResponse.setWriteCallback(new AbstractResource.WriteCallback(){

                    @Override
                    public void writeData(IResource.Attributes attributes) {
                        attributes.getResponse().write(bytes);
                    }
                });
            }
            catch (IOException e) {
                log.debug(e.getMessage(), (Throwable)e);
                return this.sendResourceError(resourceResponse, 500, "Unable to read resource stream");
            }
            catch (ResourceStreamNotFoundException e) {
                log.debug(e.getMessage(), (Throwable)e);
                return this.sendResourceError(resourceResponse, 500, "Unable to open resource stream");
            }
        }
        return resourceResponse;
    }

    private List<IResourceStream> collectResourceStreams() {
        ArrayList<IResourceStream> ret = new ArrayList<IResourceStream>(this.providedResources.size());
        for (IReferenceHeaderItem iReferenceHeaderItem : this.providedResources) {
            IResourceStream stream = ((PackageResource)iReferenceHeaderItem.getReference().getResource()).getResourceStream();
            if (stream == null) {
                return null;
            }
            ret.add(stream);
        }
        return ret;
    }

    private String findContentType(List<IResourceStream> resources) {
        for (IResourceStream curStream : resources) {
            if (curStream.getContentType() == null) continue;
            return curStream.getContentType();
        }
        return null;
    }

    private Time findLastModified(List<IResourceStream> resources) {
        Time ret = null;
        for (IResourceStream curStream : resources) {
            Time curLastModified = curStream.lastModifiedTime();
            if (ret != null && !curLastModified.after(ret)) continue;
            ret = curLastModified;
        }
        return ret;
    }

    private byte[] readAllResources(List<IResourceStream> resources) throws IOException, ResourceStreamNotFoundException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        for (IResourceStream curStream : resources) {
            IOUtils.copy(curStream.getInputStream(), (OutputStream)output);
        }
        return output.toByteArray();
    }

    private AbstractResource.ResourceResponse sendResourceError(AbstractResource.ResourceResponse resourceResponse, int errorCode, String errorMessage) {
        String msg = String.format("bundled resource: %s (status=%d)", errorMessage, errorCode);
        log.warn(msg);
        resourceResponse.setError(errorCode, errorMessage);
        return resourceResponse;
    }

    @Override
    public Serializable getCacheKey() {
        ArrayList<Serializable> key = new ArrayList<Serializable>(this.providedResources.size());
        for (IReferenceHeaderItem iReferenceHeaderItem : this.providedResources) {
            Serializable curKey = ((PackageResource)iReferenceHeaderItem.getReference().getResource()).getCacheKey();
            if (curKey == null) {
                return null;
            }
            key.add(curKey);
        }
        return key;
    }

    @Override
    public IResourceStream getCacheableResourceStream() {
        List<IResourceStream> resources = this.collectResourceStreams();
        byte[] bytes = null;
        try {
            bytes = this.readAllResources(resources);
        }
        catch (IOException e) {
            return null;
        }
        catch (ResourceStreamNotFoundException e) {
            return null;
        }
        final String contentType = this.findContentType(resources);
        final Time lastModified = this.findLastModified(resources);
        final ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        final long length = bytes.length;
        AbstractResourceStream ret = new AbstractResourceStream(){
            private static final long serialVersionUID = 1L;

            @Override
            public InputStream getInputStream() throws ResourceStreamNotFoundException {
                return inputStream;
            }

            @Override
            public Bytes length() {
                return Bytes.bytes(length);
            }

            @Override
            public String getContentType() {
                return contentType;
            }

            @Override
            public Time lastModifiedTime() {
                return lastModified;
            }

            @Override
            public void close() throws IOException {
                inputStream.close();
            }
        };
        return ret;
    }
}

