/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.resource;

import org.apache.wicket.Application;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.settings.IDebugSettings;
import org.apache.wicket.settings.IJavaScriptLibrarySettings;

public class CoreLibrariesContributor {
    public static void contribute(Application application, IHeaderResponse response) {
        IJavaScriptLibrarySettings jsLibrarySettings = application.getJavaScriptLibrarySettings();
        ResourceReference wicketEventReference = jsLibrarySettings.getWicketEventReference();
        response.render(JavaScriptHeaderItem.forReference(wicketEventReference));
    }

    public static void contributeAjax(Application application, IHeaderResponse response) {
        CoreLibrariesContributor.contribute(application, response);
        IJavaScriptLibrarySettings jsLibrarySettings = application.getJavaScriptLibrarySettings();
        ResourceReference wicketAjaxReference = jsLibrarySettings.getWicketAjaxReference();
        response.render(JavaScriptHeaderItem.forReference(wicketAjaxReference));
        IDebugSettings debugSettings = application.getDebugSettings();
        if (debugSettings.isAjaxDebugModeEnabled()) {
            response.render(JavaScriptHeaderItem.forReference(jsLibrarySettings.getWicketAjaxDebugReference()));
            response.render(JavaScriptHeaderItem.forScript("Wicket.Ajax.DebugWindow.enabled=true;", "wicket-ajax-debug-enable"));
        }
    }
}

