/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.wicket.Application;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.request.HttpHeaderCollection;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.request.http.WebResponse;
import org.apache.wicket.request.resource.ContentDisposition;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.request.resource.caching.IResourceCachingStrategy;
import org.apache.wicket.request.resource.caching.IStaticCacheableResource;
import org.apache.wicket.util.io.Streams;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.time.Duration;
import org.apache.wicket.util.time.Time;

public abstract class AbstractResource
implements IResource {
    private static final long serialVersionUID = 1L;
    public static final Set<String> INTERNAL_HEADERS = new HashSet<String>();

    protected abstract ResourceResponse newResourceResponse(IResource.Attributes var1);

    protected void configureCache(ResourceResponse data, IResource.Attributes attributes) {
        Response response = attributes.getResponse();
        if (response instanceof WebResponse) {
            Duration duration = data.getCacheDuration();
            WebResponse webResponse = (WebResponse)response;
            if (duration.compareTo(Duration.NONE) > 0) {
                webResponse.enableCaching(duration, data.getCacheScope());
            } else {
                webResponse.disableCaching();
            }
        }
    }

    protected IResourceCachingStrategy getCachingStrategy() {
        return Application.get().getResourceSettings().getCachingStrategy();
    }

    @Override
    public void respond(IResource.Attributes attributes) {
        ResourceResponse data = this.newResourceResponse(attributes);
        if (this instanceof IStaticCacheableResource) {
            this.getCachingStrategy().decorateResponse(data, (IStaticCacheableResource)((Object)this));
        }
        this.setResponseHeaders(data, attributes);
        if (!data.dataNeedsToBeWritten(attributes) || data.getErrorCode() != null) {
            return;
        }
        if (data.getWriteCallback() == null) {
            throw new IllegalStateException("ResourceResponse#setWriteCallback() must be set.");
        }
        data.getWriteCallback().writeData(attributes);
    }

    private void checkHeaderAccess(String name) {
        if (INTERNAL_HEADERS.contains(name = Args.notEmpty(name.trim().toLowerCase(), "name"))) {
            throw new IllegalArgumentException("you are not allowed to directly access header [" + name + "], " + "use one of the other specialized methods of " + this.getClass().getSimpleName() + " to get or modify its value");
        }
    }

    protected void setResponseHeaders(ResourceResponse data, IResource.Attributes attributes) {
        Response response = attributes.getResponse();
        if (response instanceof WebResponse) {
            WebResponse webResponse = (WebResponse)response;
            Time lastModified = data.getLastModified();
            if (lastModified != null) {
                webResponse.setLastModifiedTime(lastModified);
            }
            this.configureCache(data, attributes);
            if (!data.dataNeedsToBeWritten(attributes)) {
                webResponse.setStatus(304);
                return;
            }
            if (data.getErrorCode() != null) {
                webResponse.sendError(data.getErrorCode(), data.getErrorMessage());
                return;
            }
            String fileName = data.getFileName();
            ContentDisposition disposition = data.getContentDisposition();
            String mimeType = data.getContentType();
            String encoding = null;
            if (mimeType != null && mimeType.contains("text")) {
                encoding = data.getTextEncoding();
            }
            long contentLength = data.getContentLength();
            if (ContentDisposition.ATTACHMENT == disposition) {
                webResponse.setAttachmentHeader(fileName);
            } else if (ContentDisposition.INLINE == disposition) {
                webResponse.setInlineHeader(fileName);
            }
            if (mimeType != null) {
                if (encoding == null) {
                    webResponse.setContentType(mimeType);
                } else {
                    webResponse.setContentType(mimeType + "; charset=" + encoding);
                }
            }
            if (contentLength != -1L) {
                webResponse.setContentLength(contentLength);
            }
            HttpHeaderCollection headers = data.getHeaders();
            for (String name : headers.getHeaderNames()) {
                this.checkHeaderAccess(name);
                for (String value : headers.getHeaderValues(name)) {
                    webResponse.addHeader(name, value);
                }
            }
            this.flushResponseAfterHeaders(webResponse);
        }
    }

    protected void flushResponseAfterHeaders(WebResponse response) {
        response.flush();
    }

    static {
        INTERNAL_HEADERS.add("server");
        INTERNAL_HEADERS.add("date");
        INTERNAL_HEADERS.add("expires");
        INTERNAL_HEADERS.add("last-modified");
        INTERNAL_HEADERS.add("content-type");
        INTERNAL_HEADERS.add("content-length");
        INTERNAL_HEADERS.add("content-disposition");
        INTERNAL_HEADERS.add("transfer-encoding");
        INTERNAL_HEADERS.add("connection");
        INTERNAL_HEADERS.add("content-disposition");
    }

    public static abstract class WriteCallback {
        public abstract void writeData(IResource.Attributes var1);

        protected final void writeStream(IResource.Attributes attributes, InputStream stream) {
            final Response response = attributes.getResponse();
            OutputStream s = new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    response.write(new byte[]{(byte)b});
                }

                @Override
                public void write(byte[] b) throws IOException {
                    response.write(b);
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    response.write(b, off, len);
                }
            };
            try {
                Streams.copy(stream, s);
            }
            catch (IOException e) {
                throw new WicketRuntimeException(e);
            }
        }
    }

    public static class ResourceResponse {
        private Integer errorCode;
        private String errorMessage;
        private String fileName = null;
        private ContentDisposition contentDisposition = ContentDisposition.INLINE;
        private String contentType = null;
        private String textEncoding;
        private long contentLength = -1L;
        private Time lastModified = null;
        private WriteCallback writeCallback;
        private Duration cacheDuration;
        private WebResponse.CacheScope cacheScope = WebResponse.CacheScope.PRIVATE;
        private final HttpHeaderCollection headers = new HttpHeaderCollection();

        public void setError(Integer errorCode) {
            this.setError(errorCode, null);
        }

        public void setError(Integer errorCode, String errorMessage) {
            this.errorCode = errorCode;
            this.errorMessage = errorMessage;
        }

        public Integer getErrorCode() {
            return this.errorCode;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public String getFileName() {
            return this.fileName;
        }

        public void setContentDisposition(ContentDisposition contentDisposition) {
            Args.notNull(contentDisposition, "contentDisposition");
            this.contentDisposition = contentDisposition;
        }

        public ContentDisposition getContentDisposition() {
            return this.contentDisposition;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public String getContentType() {
            if (this.contentType == null && this.fileName != null) {
                this.contentType = Application.get().getMimeType(this.fileName);
            }
            return this.contentType;
        }

        public void setTextEncoding(String textEncoding) {
            this.textEncoding = textEncoding;
        }

        protected String getTextEncoding() {
            return this.textEncoding;
        }

        public void setContentLength(long contentLength) {
            this.contentLength = contentLength;
        }

        public long getContentLength() {
            return this.contentLength;
        }

        public void setLastModified(Time lastModified) {
            this.lastModified = lastModified;
        }

        public Time getLastModified() {
            return this.lastModified;
        }

        public boolean dataNeedsToBeWritten(IResource.Attributes attributes) {
            WebRequest request = (WebRequest)attributes.getRequest();
            Time ifModifiedSince = request.getIfModifiedSinceHeader();
            if (ifModifiedSince != null && this.lastModified != null) {
                Time roundedLastModified = Time.millis(this.lastModified.getMilliseconds() / 1000L * 1000L);
                return ifModifiedSince.before(roundedLastModified);
            }
            return true;
        }

        public void disableCaching() {
            this.setCacheDuration(Duration.NONE);
        }

        public void setCacheDurationToMaximum() {
            this.cacheDuration = WebResponse.MAX_CACHE_DURATION;
        }

        public void setCacheDuration(Duration duration) {
            this.cacheDuration = Args.notNull(duration, "duration");
        }

        public Duration getCacheDuration() {
            Duration duration = this.cacheDuration;
            if (duration == null && Application.exists()) {
                duration = Application.get().getResourceSettings().getDefaultCacheDuration();
            }
            return duration;
        }

        public WebResponse.CacheScope getCacheScope() {
            return this.cacheScope;
        }

        public void setCacheScope(WebResponse.CacheScope scope) {
            this.cacheScope = Args.notNull(scope, "scope");
        }

        public void setWriteCallback(WriteCallback writeCallback) {
            Args.notNull(writeCallback, "writeCallback");
            this.writeCallback = writeCallback;
        }

        public WriteCallback getWriteCallback() {
            return this.writeCallback;
        }

        public HttpHeaderCollection getHeaders() {
            return this.headers;
        }
    }
}

