/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.handler.resource;

import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.util.lang.Args;

public class ResourceRequestHandler
implements IRequestHandler {
    private final IResource resource;
    private final PageParameters pageParameters;

    public ResourceRequestHandler(IResource resource, PageParameters pageParameters) {
        Args.notNull(resource, "resource");
        this.resource = resource;
        this.pageParameters = pageParameters != null ? pageParameters : new PageParameters();
    }

    public PageParameters getPageParameters() {
        return this.pageParameters;
    }

    public IResource getResource() {
        return this.resource;
    }

    @Override
    public void respond(IRequestCycle requestCycle) {
        IResource.Attributes a = new IResource.Attributes(requestCycle.getRequest(), requestCycle.getResponse(), this.pageParameters);
        this.resource.respond(a);
    }

    @Override
    public void detach(IRequestCycle requestCycle) {
    }
}

