/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.servlet;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.core.util.string.UrlUtils;
import org.apache.wicket.protocol.http.RequestUtils;
import org.apache.wicket.protocol.http.servlet.ErrorAttributes;
import org.apache.wicket.protocol.http.servlet.ForwardAttributes;
import org.apache.wicket.protocol.http.servlet.MultipartServletWebRequest;
import org.apache.wicket.protocol.http.servlet.MultipartServletWebRequestImpl;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.IWritableRequestParameters;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.http.WebRequest;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.lang.Checks;
import org.apache.wicket.util.string.PrependingStringBuffer;
import org.apache.wicket.util.string.StringValue;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.time.Time;
import org.apache.wicket.util.upload.FileItemFactory;
import org.apache.wicket.util.upload.FileUploadException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletWebRequest
extends WebRequest {
    private final HttpServletRequest httpServletRequest;
    private final Url url;
    private final String filterPrefix;
    private final ErrorAttributes errorAttributes;
    private final ForwardAttributes forwardAttributes;
    private Map<String, List<StringValue>> postParameters = null;
    private final IRequestParameters postRequestParameters = new IWritableRequestParameters(){

        @Override
        public void reset() {
            ServletWebRequest.this.getPostRequestParameters().clear();
        }

        @Override
        public void setParameterValues(String key, List<StringValue> values) {
            ServletWebRequest.this.getPostRequestParameters().put(key, values);
        }

        @Override
        public Set<String> getParameterNames() {
            return Collections.unmodifiableSet(ServletWebRequest.this.getPostRequestParameters().keySet());
        }

        @Override
        public StringValue getParameterValue(String name) {
            List values = (List)ServletWebRequest.this.getPostRequestParameters().get(name);
            if (values == null || values.isEmpty()) {
                return StringValue.valueOf((String)null);
            }
            return (StringValue)values.iterator().next();
        }

        @Override
        public List<StringValue> getParameterValues(String name) {
            List values = (List)ServletWebRequest.this.getPostRequestParameters().get(name);
            if (values != null) {
                values = Collections.unmodifiableList(values);
            }
            return values;
        }
    };
    private static final Logger logger = LoggerFactory.getLogger(ServletWebRequest.class);

    public ServletWebRequest(HttpServletRequest httpServletRequest, String filterPrefix) {
        this(httpServletRequest, filterPrefix, null);
    }

    public ServletWebRequest(HttpServletRequest httpServletRequest, String filterPrefix, Url url) {
        Args.notNull(httpServletRequest, "httpServletRequest");
        Args.notNull(filterPrefix, "filterPrefix");
        this.httpServletRequest = httpServletRequest;
        this.errorAttributes = ErrorAttributes.of(httpServletRequest);
        this.forwardAttributes = ForwardAttributes.of(httpServletRequest);
        this.filterPrefix = this.forwardAttributes != null || this.errorAttributes != null ? "" : filterPrefix;
        this.url = url != null ? url : this.getContextRelativeUrl(httpServletRequest.getRequestURI(), filterPrefix);
    }

    @Override
    public Url getClientUrl() {
        if (this.errorAttributes != null && !Strings.isEmpty(this.errorAttributes.getRequestUri())) {
            String problematicURI = Url.parse(this.errorAttributes.getRequestUri(), this.getCharset()).toString();
            return this.getContextRelativeUrl(problematicURI, this.filterPrefix);
        }
        if (this.forwardAttributes != null && !Strings.isEmpty(this.forwardAttributes.getRequestUri())) {
            String forwardURI = Url.parse(this.forwardAttributes.getRequestUri(), this.getCharset()).toString();
            return this.getContextRelativeUrl(forwardURI, this.filterPrefix);
        }
        if (!this.isAjax()) {
            return this.getContextRelativeUrl(this.httpServletRequest.getRequestURI(), this.filterPrefix);
        }
        String base = null;
        base = this.getHeader("Wicket-Ajax-BaseURL");
        if (base == null) {
            base = this.getRequestParameters().getParameterValue("wicket-ajax-baseurl").toString(null);
        }
        Checks.notNull(base, "Current ajax request is missing the base url header or parameter", new Object[0]);
        return this.setParameters(Url.parse(base, this.getCharset()));
    }

    private Url setParameters(Url url) {
        url.setPort(this.httpServletRequest.getServerPort());
        url.setHost(this.httpServletRequest.getServerName());
        url.setProtocol(this.httpServletRequest.getScheme());
        return url;
    }

    private Url getContextRelativeUrl(String uri, String filterPrefix) {
        String query;
        if (filterPrefix.length() > 0 && !filterPrefix.endsWith("/")) {
            filterPrefix = filterPrefix + "/";
        }
        StringBuilder url = new StringBuilder();
        uri = Strings.stripJSessionId(uri);
        int start = this.httpServletRequest.getContextPath().length() + filterPrefix.length() + 1;
        url.append(uri.substring(start));
        if (this.errorAttributes == null && !Strings.isEmpty(query = this.httpServletRequest.getQueryString())) {
            url.append('?');
            url.append(query);
        }
        return this.setParameters(Url.parse(url.toString(), this.getCharset()));
    }

    public String getFilterPrefix() {
        return this.filterPrefix;
    }

    @Override
    public List<Cookie> getCookies() {
        Cookie[] cookies = this.httpServletRequest.getCookies();
        List<Object> result = cookies == null ? Collections.emptyList() : Arrays.asList(cookies);
        return Collections.unmodifiableList(result);
    }

    @Override
    public Locale getLocale() {
        return this.httpServletRequest.getLocale();
    }

    @Override
    public Time getDateHeader(String name) {
        try {
            long value = this.httpServletRequest.getDateHeader(name);
            if (value == -1L) {
                return null;
            }
            return Time.millis(value);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public String getHeader(String name) {
        return this.httpServletRequest.getHeader(name);
    }

    @Override
    public List<String> getHeaders(String name) {
        ArrayList result = new ArrayList();
        Enumeration e = this.httpServletRequest.getHeaders(name);
        while (e.hasMoreElements()) {
            result.add(e.nextElement());
        }
        return Collections.unmodifiableList(result);
    }

    private static boolean isMultiPart(ServletRequest request) {
        String contentType = request.getContentType();
        return contentType != null && contentType.toLowerCase().contains("multipart");
    }

    protected Map<String, List<StringValue>> generatePostParameters() {
        HashMap<String, List<StringValue>> postParameters = new HashMap<String, List<StringValue>>();
        IRequestParameters queryParams = this.getQueryParameters();
        Map params = this.getContainerRequest().getParameterMap();
        for (Map.Entry param : params.entrySet()) {
            String name = (String)param.getKey();
            String[] values = (String[])param.getValue();
            List<StringValue> queryValues = queryParams.getParameterValues(name);
            queryValues = queryValues == null ? Collections.emptyList() : new ArrayList<StringValue>(queryValues);
            ArrayList<StringValue> postValues = new ArrayList<StringValue>();
            for (String value : values) {
                StringValue val = StringValue.valueOf(value);
                if (queryValues.contains(val)) {
                    queryValues.remove(val);
                    continue;
                }
                postValues.add(val);
            }
            if (postValues.isEmpty()) continue;
            postParameters.put(name, postValues);
        }
        return postParameters;
    }

    private Map<String, List<StringValue>> getPostRequestParameters() {
        if (this.postParameters == null) {
            this.postParameters = this.generatePostParameters();
        }
        return this.postParameters;
    }

    @Override
    public IRequestParameters getPostParameters() {
        return this.postRequestParameters;
    }

    @Override
    public Url getUrl() {
        return new Url(this.url);
    }

    @Override
    public ServletWebRequest cloneWithUrl(Url url) {
        return new ServletWebRequest(this.httpServletRequest, this.filterPrefix, url){

            @Override
            public IRequestParameters getPostParameters() {
                return ServletWebRequest.this.getPostParameters();
            }
        };
    }

    public MultipartServletWebRequest newMultipartWebRequest(Bytes maxSize, String upload) throws FileUploadException {
        return new MultipartServletWebRequestImpl(this.getContainerRequest(), this.filterPrefix, maxSize, upload);
    }

    public MultipartServletWebRequest newMultipartWebRequest(Bytes maxSize, String upload, FileItemFactory factory) throws FileUploadException {
        return new MultipartServletWebRequestImpl(this.getContainerRequest(), this.filterPrefix, maxSize, upload, factory);
    }

    @Override
    public String getPrefixToContextPath() {
        PrependingStringBuffer buffer = new PrependingStringBuffer();
        Url filterPrefixUrl = Url.parse(this.filterPrefix, this.getCharset());
        for (int i = 0; i < filterPrefixUrl.getSegments().size() - 1; ++i) {
            buffer.prepend("../");
        }
        return buffer.toString();
    }

    @Override
    public Charset getCharset() {
        return RequestUtils.getCharset(this.httpServletRequest);
    }

    public HttpServletRequest getContainerRequest() {
        return this.httpServletRequest;
    }

    @Override
    public String getContextPath() {
        return UrlUtils.normalizePath(this.httpServletRequest.getContextPath());
    }

    @Override
    public String getFilterPath() {
        return UrlUtils.normalizePath(this.filterPrefix);
    }

    @Override
    public boolean shouldPreserveClientUrl() {
        return this.errorAttributes != null && !Strings.isEmpty(this.errorAttributes.getRequestUri()) || this.forwardAttributes != null && !Strings.isEmpty(this.forwardAttributes.getRequestUri());
    }
}

