/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.Application;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.protocol.http.servlet.MultipartServletWebRequest;
import org.apache.wicket.protocol.http.servlet.UploadInfo;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.string.StringValue;
import org.apache.wicket.util.upload.DiskFileItemFactory;
import org.apache.wicket.util.upload.FileItem;
import org.apache.wicket.util.upload.FileItemFactory;
import org.apache.wicket.util.upload.FileUploadException;
import org.apache.wicket.util.upload.ServletFileUpload;
import org.apache.wicket.util.upload.ServletRequestContext;
import org.apache.wicket.util.value.ValueMap;

public class MultipartServletWebRequestImpl
extends MultipartServletWebRequest {
    private final Map<String, List<FileItem>> files;
    private final ValueMap parameters;
    private final String upload;
    private int bytesUploaded;
    private int totalBytes;
    private static final String SESSION_KEY = MultipartServletWebRequestImpl.class.getName();

    public MultipartServletWebRequestImpl(HttpServletRequest request, String filterPrefix, Bytes maxSize, String upload) throws FileUploadException {
        this(request, filterPrefix, maxSize, upload, new DiskFileItemFactory(Application.get().getResourceSettings().getFileCleaner()));
    }

    public MultipartServletWebRequestImpl(HttpServletRequest request, String filterPrefix, Bytes maxSize, String upload, FileItemFactory factory) throws FileUploadException {
        super(request, filterPrefix);
        List<FileItem> items;
        Args.notNull(maxSize, "maxSize");
        Args.notNull(upload, "upload");
        this.upload = upload;
        this.parameters = new ValueMap();
        this.files = new HashMap<String, List<FileItem>>();
        boolean isMultipart = ServletFileUpload.isMultipartContent(request);
        if (!isMultipart) {
            throw new IllegalStateException("ServletRequest does not contain multipart content. One possible solution is to explicitly call Form.setMultipart(true), Wicket tries its best to auto-detect multipart forms but there are certain situation where it cannot.");
        }
        ServletFileUpload fileUpload = new ServletFileUpload(factory);
        String encoding = request.getCharacterEncoding();
        if (encoding == null) {
            encoding = Application.get().getRequestCycleSettings().getResponseRequestEncoding();
        }
        if (encoding != null) {
            fileUpload.setHeaderEncoding(encoding);
        }
        fileUpload.setSizeMax(maxSize.bytes());
        if (this.wantUploadProgressUpdates()) {
            ServletRequestContext ctx = new ServletRequestContext(request){

                @Override
                public InputStream getInputStream() throws IOException {
                    return new CountingInputStream(super.getInputStream());
                }
            };
            this.totalBytes = request.getContentLength();
            this.onUploadStarted(this.totalBytes);
            items = fileUpload.parseRequest(ctx);
            this.onUploadCompleted();
        } else {
            items = fileUpload.parseRequest(request);
        }
        for (FileItem item : items) {
            if (item.isFormField()) {
                String value;
                if (encoding != null) {
                    try {
                        value = item.getString(encoding);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new WicketRuntimeException(e);
                    }
                } else {
                    value = item.getString();
                }
                this.addParameter(item.getFieldName(), value);
                continue;
            }
            List<FileItem> fileItems = this.files.get(item.getFieldName());
            if (fileItems == null) {
                fileItems = new ArrayList<FileItem>();
                this.files.put(item.getFieldName(), fileItems);
            }
            fileItems.add(item);
        }
    }

    private void addParameter(String name, String value) {
        String[] currVal = (String[])this.parameters.get(name);
        String[] newVal = null;
        if (currVal != null) {
            newVal = new String[currVal.length + 1];
            System.arraycopy(currVal, 0, newVal, 0, currVal.length);
            newVal[currVal.length] = value;
        } else {
            newVal = new String[]{value};
        }
        this.parameters.put(name, (Object)newVal);
    }

    @Override
    public Map<String, List<FileItem>> getFiles() {
        return this.files;
    }

    @Override
    public List<FileItem> getFile(String fieldName) {
        return this.files.get(fieldName);
    }

    @Override
    protected Map<String, List<StringValue>> generatePostParameters() {
        HashMap<String, List<StringValue>> res = new HashMap<String, List<StringValue>>();
        for (String key : this.parameters.keySet()) {
            String[] val = (String[])this.parameters.get(key);
            if (val == null || val.length <= 0) continue;
            ArrayList<StringValue> items = new ArrayList<StringValue>();
            for (String s : val) {
                items.add(StringValue.valueOf(s));
            }
            res.put(key, items);
        }
        return res;
    }

    protected boolean wantUploadProgressUpdates() {
        return Application.get().getApplicationSettings().isUploadProgressUpdatesEnabled();
    }

    protected void onUploadStarted(int totalBytes) {
        UploadInfo info = new UploadInfo(totalBytes);
        MultipartServletWebRequestImpl.setUploadInfo(this.getContainerRequest(), this.upload, info);
    }

    protected void onUploadUpdate(int bytesUploaded, int total) {
        HttpServletRequest request = this.getContainerRequest();
        UploadInfo info = MultipartServletWebRequestImpl.getUploadInfo(request, this.upload);
        if (info == null) {
            throw new IllegalStateException("could not find UploadInfo object in session which should have been set when uploaded started");
        }
        info.setBytesUploaded(bytesUploaded);
        MultipartServletWebRequestImpl.setUploadInfo(request, this.upload, info);
    }

    protected void onUploadCompleted() {
        MultipartServletWebRequestImpl.clearUploadInfo(this.getContainerRequest(), this.upload);
    }

    @Override
    public MultipartServletWebRequest newMultipartWebRequest(Bytes maxSize, String upload) throws FileUploadException {
        return this;
    }

    @Override
    public MultipartServletWebRequest newMultipartWebRequest(Bytes maxSize, String upload, FileItemFactory factory) throws FileUploadException {
        return this;
    }

    private static String getSessionKey(String upload) {
        return SESSION_KEY + ":" + upload;
    }

    public static UploadInfo getUploadInfo(HttpServletRequest req, String upload) {
        Args.notNull(req, "req");
        return (UploadInfo)req.getSession().getAttribute(MultipartServletWebRequestImpl.getSessionKey(upload));
    }

    public static void setUploadInfo(HttpServletRequest req, String upload, UploadInfo uploadInfo) {
        Args.notNull(req, "req");
        Args.notNull(upload, "upload");
        Args.notNull(uploadInfo, "uploadInfo");
        req.getSession().setAttribute(MultipartServletWebRequestImpl.getSessionKey(upload), (Object)uploadInfo);
    }

    public static void clearUploadInfo(HttpServletRequest req, String upload) {
        Args.notNull(req, "req");
        Args.notNull(upload, "upload");
        req.getSession().removeAttribute(MultipartServletWebRequestImpl.getSessionKey(upload));
    }

    private class CountingInputStream
    extends InputStream {
        private final InputStream in;

        public CountingInputStream(InputStream in) {
            this.in = in;
        }

        @Override
        public int read() throws IOException {
            int read = this.in.read();
            MultipartServletWebRequestImpl.this.bytesUploaded += read < 0 ? 0 : 1;
            MultipartServletWebRequestImpl.this.onUploadUpdate(MultipartServletWebRequestImpl.this.bytesUploaded, MultipartServletWebRequestImpl.this.totalBytes);
            return read;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int read = this.in.read(b);
            MultipartServletWebRequestImpl.this.bytesUploaded += read < 0 ? 0 : read;
            MultipartServletWebRequestImpl.this.onUploadUpdate(MultipartServletWebRequestImpl.this.bytesUploaded, MultipartServletWebRequestImpl.this.totalBytes);
            return read;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int read = this.in.read(b, off, len);
            MultipartServletWebRequestImpl.this.bytesUploaded += read < 0 ? 0 : read;
            MultipartServletWebRequestImpl.this.onUploadUpdate(MultipartServletWebRequestImpl.this.bytesUploaded, MultipartServletWebRequestImpl.this.totalBytes);
            return read;
        }
    }
}

