/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.servlet;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.string.Strings;

public abstract class AbstractRequestWrapperFactory {
    private static final Pattern commaSeparatedValuesPattern = Pattern.compile("\\s*,\\s*");
    private boolean enabled = true;

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public HttpServletRequest getWrapper(HttpServletRequest request) {
        if (this.isEnabled() && this.needsWrapper(request)) {
            return this.newRequestWrapper(request);
        }
        return request;
    }

    abstract boolean needsWrapper(HttpServletRequest var1);

    public abstract HttpServletRequest newRequestWrapper(HttpServletRequest var1);

    public static final Pattern[] commaDelimitedListToPatternArray(String commaDelimitedPatterns) {
        String[] patterns = AbstractRequestWrapperFactory.commaDelimitedListToStringArray(commaDelimitedPatterns);
        ArrayList<Pattern> patternsList = Generics.newArrayList();
        for (String pattern : patterns) {
            try {
                patternsList.add(Pattern.compile(pattern));
            }
            catch (PatternSyntaxException e) {
                throw new IllegalArgumentException("Illegal pattern syntax '" + pattern + "'", e);
            }
        }
        return patternsList.toArray(new Pattern[patternsList.size()]);
    }

    public static final String[] commaDelimitedListToStringArray(String commaDelimitedStrings) {
        if (Strings.isEmpty(commaDelimitedStrings)) {
            return new String[0];
        }
        return commaSeparatedValuesPattern.split(commaDelimitedStrings);
    }

    public static final String listToCommaDelimitedString(List<String> stringList) {
        return Strings.join(", ", stringList);
    }

    public static final boolean matchesOne(String str, Pattern ... patterns) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(str).matches()) continue;
            return true;
        }
        return false;
    }
}

