/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.request;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.core.request.ClientInfo;
import org.apache.wicket.protocol.http.ClientProperties;
import org.apache.wicket.protocol.http.request.UserAgent;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebClientInfo
extends ClientInfo {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(WebClientInfo.class);
    private final String userAgent;
    private final ClientProperties properties = new ClientProperties();

    public WebClientInfo(RequestCycle requestCycle) {
        this(requestCycle, ((ServletWebRequest)requestCycle.getRequest()).getContainerRequest().getHeader("User-Agent"));
    }

    public WebClientInfo(RequestCycle requestCycle, String userAgent) {
        this.userAgent = userAgent;
        this.properties.setRemoteAddress(this.getRemoteAddr(requestCycle));
        this.init();
    }

    public final ClientProperties getProperties() {
        return this.properties;
    }

    public final String getUserAgent() {
        return this.userAgent;
    }

    private String getUserAgentStringLc() {
        return this.getUserAgent() != null ? this.getUserAgent().toLowerCase() : "";
    }

    protected String getRemoteAddr(RequestCycle requestCycle) {
        ServletWebRequest request = (ServletWebRequest)requestCycle.getRequest();
        HttpServletRequest req = request.getContainerRequest();
        String remoteAddr = request.getHeader("X-Forwarded-For");
        if (remoteAddr == null) {
            remoteAddr = req.getRemoteAddr();
        } else if (remoteAddr.contains(",")) {
            remoteAddr = Strings.split(remoteAddr, ',')[0].trim();
        }
        return remoteAddr;
    }

    private final void init() {
        this.setInternetExplorerProperties();
        this.setOperaProperties();
        this.setMozillaProperties();
        this.setKonquerorProperties();
        this.setChromeProperties();
        this.setSafariProperties();
        if (log.isDebugEnabled()) {
            log.debug("determined user agent: " + this.properties);
        }
    }

    private void setKonquerorProperties() {
        this.properties.setBrowserKonqueror(UserAgent.KONQUEROR.matches(this.getUserAgent()));
        if (this.properties.isBrowserKonqueror()) {
            this.setMajorMinorVersionByPattern("konqueror/(\\d+)\\.(\\d+)");
        }
    }

    private void setChromeProperties() {
        this.properties.setBrowserChrome(UserAgent.CHROME.matches(this.getUserAgent()));
        if (this.properties.isBrowserChrome()) {
            this.setMajorMinorVersionByPattern("chrome/(\\d+)\\.(\\d+)");
        }
    }

    private void setSafariProperties() {
        String userAgent;
        this.properties.setBrowserSafari(UserAgent.SAFARI.matches(this.getUserAgent()));
        if (this.properties.isBrowserSafari() && (userAgent = this.getUserAgentStringLc()).contains("version/")) {
            this.setMajorMinorVersionByPattern("version/(\\d+)\\.(\\d+)");
        }
    }

    private void setMozillaProperties() {
        this.properties.setBrowserMozillaFirefox(UserAgent.FIREFOX.matches(this.getUserAgent()));
        this.properties.setBrowserMozilla(UserAgent.MOZILLA.matches(this.getUserAgent()));
        if (this.properties.isBrowserMozilla()) {
            this.properties.setQuirkMozillaTextInputRepaint(true);
            this.properties.setQuirkMozillaPerformanceLargeDomRemove(true);
            if (this.properties.isBrowserMozillaFirefox()) {
                this.setMajorMinorVersionByPattern("firefox/(\\d+)\\.(\\d+)");
            }
        }
    }

    private void setOperaProperties() {
        this.properties.setBrowserOpera(UserAgent.OPERA.matches(this.getUserAgent()));
        if (this.properties.isBrowserOpera()) {
            String userAgent = this.getUserAgentStringLc();
            if (userAgent.startsWith("opera/") && userAgent.contains("version/")) {
                this.setMajorMinorVersionByPattern("version/(\\d+)\\.(\\d+)");
            } else if (userAgent.startsWith("opera/") && !userAgent.contains("version/")) {
                this.setMajorMinorVersionByPattern("opera/(\\d+)\\.(\\d+)");
            } else {
                this.setMajorMinorVersionByPattern("opera (\\d+)\\.(\\d+)");
            }
        }
    }

    private void setInternetExplorerProperties() {
        this.properties.setBrowserInternetExplorer(UserAgent.INTERNET_EXPLORER.matches(this.getUserAgent()));
        if (this.properties.isBrowserInternetExplorer()) {
            this.setMajorMinorVersionByPattern("msie (\\d+)\\.(\\d+)");
            this.properties.setProprietaryIECssExpressionsSupported(true);
            this.properties.setQuirkCssPositioningOneSideOnly(true);
            this.properties.setQuirkIERepaint(true);
            this.properties.setQuirkIESelectZIndex(true);
            this.properties.setQuirkIETextareaNewlineObliteration(true);
            this.properties.setQuirkIESelectPercentWidth(true);
            this.properties.setQuirkIESelectListDomUpdate(true);
            this.properties.setQuirkIETablePercentWidthScrollbarError(true);
            this.properties.setQuirkCssBackgroundAttachmentUseFixed(true);
            this.properties.setQuirkCssBorderCollapseInside(true);
            this.properties.setQuirkCssBorderCollapseFor0Padding(true);
            if (this.properties.getBrowserVersionMajor() < 7) {
                this.properties.setProprietaryIEPngAlphaFilterRequired(true);
            }
        }
    }

    private void setMajorMinorVersionByPattern(String patternString) {
        String userAgent = this.getUserAgentStringLc();
        Matcher matcher = Pattern.compile(patternString).matcher(userAgent);
        if (matcher.find()) {
            this.properties.setBrowserVersionMajor(Integer.parseInt(matcher.group(1)));
            this.properties.setBrowserVersionMinor(Integer.parseInt(matcher.group(2)));
        }
    }
}

