/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.pageStore.memory;

import org.apache.wicket.pageStore.memory.IDataStoreEvictionStrategy;
import org.apache.wicket.pageStore.memory.PageTable;
import org.apache.wicket.pageStore.memory.PageTableCleaner;

public class PageNumberEvictionStrategy
implements IDataStoreEvictionStrategy {
    private final int pagesNumber;

    public PageNumberEvictionStrategy(int pagesNumber) {
        if (pagesNumber < 1) {
            throw new IllegalArgumentException("'pagesNumber' must be greater than 0.");
        }
        this.pagesNumber = pagesNumber;
    }

    @Override
    public void evict(PageTable pageTable) {
        int size = pageTable.size();
        int pagesToDrop = size - this.pagesNumber;
        if (pagesToDrop > 0) {
            PageTableCleaner cleaner = new PageTableCleaner();
            cleaner.drop(pageTable, pagesToDrop);
        }
    }
}

