/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.transformer;

import org.apache.wicket.Component;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.transformer.ITransformer;
import org.apache.wicket.protocol.http.BufferedWebResponse;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebResponse;

public abstract class AbstractTransformerBehavior
extends Behavior
implements ITransformer {
    private static final long serialVersionUID = 1L;
    private transient Response originalResponse;

    protected BufferedWebResponse newResponse(WebResponse originalResponse) {
        return new BufferedWebResponse(originalResponse);
    }

    @Override
    public void beforeRender(Component component) {
        super.beforeRender(component);
        RequestCycle requestCycle = RequestCycle.get();
        this.originalResponse = requestCycle.getResponse();
        WebResponse origResponse = (WebResponse)(this.originalResponse instanceof WebResponse ? this.originalResponse : null);
        BufferedWebResponse tempResponse = this.newResponse(origResponse);
        requestCycle.setResponse(tempResponse);
    }

    @Override
    public void afterRender(Component component) {
        RequestCycle requestCycle = RequestCycle.get();
        try {
            BufferedWebResponse tempResponse = (BufferedWebResponse)requestCycle.getResponse();
            CharSequence output = this.transform(component, tempResponse.getText());
            this.originalResponse.write(output);
        }
        catch (Exception ex) {
            throw new WicketRuntimeException("Error while transforming the output of component: " + component, ex);
        }
        finally {
            requestCycle.setResponse(this.originalResponse);
        }
    }

    @Override
    public void detach(Component component) {
        this.originalResponse = null;
        super.detach(component);
    }

    @Override
    public abstract CharSequence transform(Component var1, CharSequence var2) throws Exception;
}

