/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.repeater;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.wicket.markup.html.navigation.paging.IPageableItems;
import org.apache.wicket.markup.repeater.RefreshingView;
import org.apache.wicket.model.IModel;

public abstract class AbstractPageableView<T>
extends RefreshingView<T>
implements IPageableItems {
    private static final long serialVersionUID = 1L;
    private long itemsPerPage = Long.MAX_VALUE;
    private long currentPage;
    private transient long cachedItemCount;

    public AbstractPageableView(String id, IModel<? extends Collection<? extends T>> model) {
        super(id, model);
        this.clearCachedItemCount();
    }

    public AbstractPageableView(String id) {
        super(id);
        this.clearCachedItemCount();
    }

    @Override
    protected Iterator<IModel<T>> getItemModels() {
        long offset = this.getFirstItemOffset();
        long size = this.getViewSize();
        Iterator<IModel<T>> models = this.getItemModels(offset, size);
        models = new CappedIteratorAdapter<T>(models, size);
        return models;
    }

    @Override
    protected void onBeforeRender() {
        this.clearCachedItemCount();
        super.onBeforeRender();
    }

    protected abstract Iterator<IModel<T>> getItemModels(long var1, long var3);

    private void clearCachedItemCount() {
        this.cachedItemCount = -1L;
    }

    private void setCachedItemCount(long itemCount) {
        this.cachedItemCount = itemCount;
    }

    private long getCachedItemCount() {
        if (this.cachedItemCount < 0L) {
            throw new IllegalStateException("getItemCountCache() called when cache was not set");
        }
        return this.cachedItemCount;
    }

    private boolean isItemCountCached() {
        return this.cachedItemCount >= 0L;
    }

    @Override
    public long getItemsPerPage() {
        return this.itemsPerPage;
    }

    public final void setItemsPerPage(long items) {
        if (items < 1L) {
            throw new IllegalArgumentException("Argument [itemsPerPage] cannot be less than 1");
        }
        if (this.itemsPerPage != items && this.isVersioned()) {
            this.addStateChange();
        }
        this.itemsPerPage = items;
        this.setCurrentPage(0L);
    }

    protected abstract long internalGetItemCount();

    public final long getRowCount() {
        if (!this.isVisibleInHierarchy()) {
            return 0L;
        }
        return this.getItemCount();
    }

    @Override
    public final long getItemCount() {
        if (this.isItemCountCached()) {
            return this.getCachedItemCount();
        }
        long count = this.internalGetItemCount();
        this.setCachedItemCount(count);
        return count;
    }

    @Override
    public final long getCurrentPage() {
        long page = this.currentPage;
        if (page > 0L && page >= this.getPageCount()) {
            this.currentPage = page = Math.max(this.getPageCount() - 1L, 0L);
            return page;
        }
        return page;
    }

    @Override
    public final void setCurrentPage(long page) {
        if (this.currentPage != page && this.isVersioned()) {
            this.addStateChange();
        }
        this.currentPage = page;
    }

    @Override
    public final long getPageCount() {
        long count;
        long total = this.getRowCount();
        long itemsPerPage = this.getItemsPerPage();
        if (itemsPerPage * (count = total / itemsPerPage) < total) {
            ++count;
        }
        return count;
    }

    public long getFirstItemOffset() {
        return this.getCurrentPage() * this.getItemsPerPage();
    }

    public long getViewSize() {
        return Math.min(this.getItemsPerPage(), this.getRowCount() - this.getFirstItemOffset());
    }

    @Override
    protected void onDetach() {
        this.clearCachedItemCount();
        super.onDetach();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.clearCachedItemCount();
    }

    private static class CappedIteratorAdapter<T>
    implements Iterator<IModel<T>> {
        private final long max;
        private long index;
        private final Iterator<IModel<T>> delegate;

        public CappedIteratorAdapter(Iterator<IModel<T>> delegate, long max) {
            this.delegate = delegate;
            this.max = max;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < this.max && this.delegate.hasNext();
        }

        @Override
        public IModel<T> next() {
            if (this.index >= this.max) {
                throw new NoSuchElementException();
            }
            ++this.index;
            return this.delegate.next();
        }
    }
}

