/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.renderStrategy;

import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.application.HeaderContributorListenerCollection;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.internal.HtmlHeaderContainer;
import org.apache.wicket.markup.renderStrategy.ChildFirstHeaderRenderStrategy;
import org.apache.wicket.markup.renderStrategy.IHeaderRenderStrategy;
import org.apache.wicket.util.lang.Args;

public abstract class AbstractHeaderRenderStrategy
implements IHeaderRenderStrategy {
    public static IHeaderRenderStrategy get() {
        String className = System.getProperty("Wicket_HeaderRenderStrategy");
        if (className != null) {
            Class<?> clazz = null;
            try {
                clazz = Application.get().getApplicationSettings().getClassResolver().resolveClass(className);
                if (clazz != null) {
                    return (IHeaderRenderStrategy)clazz.newInstance();
                }
            }
            catch (ClassNotFoundException ex) {
            }
            catch (InstantiationException ex) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return new ChildFirstHeaderRenderStrategy();
    }

    @Override
    public void renderHeader(HtmlHeaderContainer headerContainer, HtmlHeaderContainer.HeaderStreamState headerStreamState, Component rootComponent) {
        Args.notNull(headerContainer, "headerContainer");
        Args.notNull(rootComponent, "rootComponent");
        this.renderApplicationLevelHeaders(headerContainer);
        this.renderRootComponent(headerContainer, headerStreamState, rootComponent);
        this.renderChildHeaders(headerContainer, rootComponent);
    }

    protected void renderRootComponent(HtmlHeaderContainer headerContainer, HtmlHeaderContainer.HeaderStreamState headerStreamState, Component rootComponent) {
        headerContainer.renderHeaderTagBody(headerStreamState);
        rootComponent.renderHead(headerContainer);
    }

    protected abstract void renderChildHeaders(HtmlHeaderContainer var1, Component var2);

    protected final void renderApplicationLevelHeaders(HtmlHeaderContainer headerContainer) {
        Args.notNull(headerContainer, "headerContainer");
        if (Application.exists()) {
            HeaderContributorListenerCollection headerContributorListenerCollection = Application.get().getHeaderContributorListenerCollection();
            IHeaderResponse headerResponse = headerContainer.getHeaderResponse();
            for (IHeaderContributor listener : headerContributorListenerCollection) {
                listener.renderHead(headerResponse);
            }
        }
    }
}

