/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.parser.filter;

import java.text.ParseException;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupResourceStream;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.TransparentWebMarkupContainer;
import org.apache.wicket.markup.html.WebComponent;
import org.apache.wicket.markup.parser.AbstractMarkupFilter;
import org.apache.wicket.markup.resolver.IComponentResolver;
import org.apache.wicket.util.string.Strings;

public final class WicketMessageTagHandler
extends AbstractMarkupFilter
implements IComponentResolver {
    private static final long serialVersionUID = 1L;
    public static final String WICKET_MESSAGE_CONTAINER_ID = "_message_attr_";

    public WicketMessageTagHandler() {
        this(null);
    }

    public WicketMessageTagHandler(MarkupResourceStream markupResourceStream) {
        super(markupResourceStream);
    }

    @Override
    protected final MarkupElement onComponentTag(ComponentTag tag) throws ParseException {
        if (tag.isClose()) {
            return tag;
        }
        String wicketMessageAttribute = tag.getAttributes().getString(this.getWicketMessageAttrName());
        if (wicketMessageAttribute != null && wicketMessageAttribute.trim().length() > 0) {
            if (tag.getId() == null) {
                tag.setId(WICKET_MESSAGE_CONTAINER_ID);
                tag.setAutoComponentTag(true);
                tag.setModified(true);
            }
            tag.addBehavior(new AttributeLocalizer(this.getWicketMessageAttrName()));
        }
        return tag;
    }

    @Override
    public Component resolve(MarkupContainer container, MarkupStream markupStream, ComponentTag tag) {
        if (tag != null && tag.getId().startsWith(WICKET_MESSAGE_CONTAINER_ID)) {
            Component wc = null;
            int autoIndex = container.getPage().getAutoIndex();
            String id = WICKET_MESSAGE_CONTAINER_ID + autoIndex;
            wc = tag.isOpenClose() ? new WebComponent(id) : new TransparentWebMarkupContainer(id);
            return wc;
        }
        return null;
    }

    private String getWicketMessageAttrName() {
        String wicketNamespace = this.getWicketNamespace();
        return wicketNamespace + ':' + "message";
    }

    public static class AttributeLocalizer
    extends Behavior {
        private static final long serialVersionUID = 1L;
        private final String wicketMessageAttrName;

        public AttributeLocalizer(String wicketMessageAttrName) {
            this.wicketMessageAttrName = wicketMessageAttrName;
        }

        @Override
        public void onComponentTag(Component component, ComponentTag tag) {
            String expr = tag.getAttributes().getString(this.wicketMessageAttrName);
            if (!Strings.isEmpty(expr)) {
                String[] attrsAndKeys;
                expr = expr.trim();
                for (String attrAndKey : attrsAndKeys = Strings.split(expr, ',')) {
                    int colon = attrAndKey.lastIndexOf(":");
                    if (attrAndKey.length() < 3 || colon < 1 || colon > attrAndKey.length() - 2) {
                        throw new WicketRuntimeException("wicket:message attribute contains an invalid value [[" + expr + "]], must be of form (attr:key)+");
                    }
                    String attr = attrAndKey.substring(0, colon);
                    String key = attrAndKey.substring(colon + 1);
                    String value = tag.getAttributes().containsKey(attr) ? component.getString(key, null, tag.getAttributes().getString(attr)) : component.getString(key);
                    tag.put(attr, value);
                }
            }
        }
    }
}

