/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.list;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.markup.IMarkupFragment;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListItemModel;
import org.apache.wicket.markup.repeater.AbstractRepeater;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.collections.ReadOnlyIterator;

public abstract class ListView<T>
extends AbstractRepeater {
    private static final long serialVersionUID = 1L;
    private int firstIndex = 0;
    private boolean reuseItems = false;
    private int viewSize = Integer.MAX_VALUE;

    public ListView(String id) {
        super(id);
    }

    public ListView(String id, IModel<? extends List<? extends T>> model) {
        super(id, model);
        if (model == null) {
            throw new IllegalArgumentException("Null models are not allowed. If you have no model, you may prefer a Loop instead");
        }
    }

    public ListView(String id, List<? extends T> list) {
        this(id, Model.ofList(list));
    }

    public final List<? extends T> getList() {
        List list = (List)this.getDefaultModelObject();
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public boolean getReuseItems() {
        return this.reuseItems;
    }

    public final int getStartIndex() {
        return this.firstIndex;
    }

    public int getViewSize() {
        int size = this.viewSize;
        Object modelObject = this.getDefaultModelObject();
        if (modelObject == null) {
            return size == Integer.MAX_VALUE ? 0 : size;
        }
        int modelSize = this.getList().size();
        if (this.firstIndex > modelSize) {
            return 0;
        }
        if (size == Integer.MAX_VALUE || this.firstIndex + size > modelSize) {
            size = modelSize - this.firstIndex;
        }
        if (Integer.MAX_VALUE - size < this.firstIndex) {
            throw new IllegalStateException("firstIndex + size must be smaller than Integer.MAX_VALUE");
        }
        return size;
    }

    public final Link<Void> moveDownLink(String id, final ListItem<T> item) {
        return new Link<Void>(id){
            private static final long serialVersionUID = 1L;

            @Override
            public void onClick() {
                int index = item.getIndex();
                if (index != -1) {
                    this.addStateChange();
                    Collections.swap(ListView.this.getList(), index, index + 1);
                    ListView.this.removeAll();
                }
            }

            @Override
            public boolean isEnabled() {
                return item.getIndex() != ListView.this.getList().size() - 1;
            }
        };
    }

    public final Link<Void> moveUpLink(String id, final ListItem<T> item) {
        return new Link<Void>(id){
            private static final long serialVersionUID = 1L;

            @Override
            public void onClick() {
                int index = item.getIndex();
                if (index != -1) {
                    this.addStateChange();
                    Collections.swap(ListView.this.getList(), index, index - 1);
                    ListView.this.removeAll();
                }
            }

            @Override
            public boolean isEnabled() {
                return item.getIndex() != 0;
            }
        };
    }

    public final Link<Void> removeLink(String id, final ListItem<T> item) {
        return new Link<Void>(id){
            private static final long serialVersionUID = 1L;

            @Override
            public void onClick() {
                this.addStateChange();
                item.modelChanging();
                ListView.this.getList().remove(item.getIndex());
                ListView.this.modelChanged();
                ListView.this.removeAll();
            }
        };
    }

    public ListView<T> setList(List<? extends T> list) {
        this.setDefaultModel((IModel)Model.ofList(list));
        return this;
    }

    public ListView<T> setReuseItems(boolean reuseItems) {
        this.reuseItems = reuseItems;
        return this;
    }

    public ListView<T> setStartIndex(int startIndex) {
        this.firstIndex = startIndex;
        if (this.firstIndex < 0) {
            this.firstIndex = 0;
        } else if (this.firstIndex > this.getList().size()) {
            this.firstIndex = 0;
        }
        return this;
    }

    public ListView<T> setViewSize(int size) {
        this.viewSize = size;
        if (this.viewSize < 0) {
            this.viewSize = Integer.MAX_VALUE;
        }
        return this;
    }

    protected IModel<T> getListItemModel(IModel<? extends List<T>> listViewModel, int index) {
        return new ListItemModel(this, index);
    }

    protected ListItem<T> newItem(int index, IModel<T> itemModel) {
        return new ListItem<T>(index, itemModel);
    }

    @Override
    protected final void onPopulate() {
        int size = this.getViewSize();
        if (size > 0) {
            if (this.getReuseItems()) {
                int maxIndex = this.firstIndex + size;
                Iterator<Component> iterator = this.iterator();
                while (iterator.hasNext()) {
                    int index;
                    ListItem child = (ListItem)iterator.next();
                    if (child == null || (index = child.getIndex()) >= this.firstIndex && index < maxIndex) continue;
                    iterator.remove();
                }
            } else {
                this.removeAll();
            }
            boolean hasChildren = this.size() != 0;
            for (int i = 0; i < size; ++i) {
                int index = this.firstIndex + i;
                ListItem<T> item = null;
                if (hasChildren) {
                    item = (ListItem<T>)this.get(Integer.toString(index));
                }
                if (item != null) continue;
                item = this.newItem(index, this.getListItemModel(this.getModel(), index));
                this.add(item);
                this.onBeginPopulateItem(item);
                this.populateItem(item);
            }
        } else {
            this.removeAll();
        }
    }

    protected void onBeginPopulateItem(ListItem<T> item) {
    }

    protected abstract void populateItem(ListItem<T> var1);

    @Override
    protected final void renderChild(Component child) {
        this.renderItem((ListItem)child);
    }

    protected void renderItem(ListItem<?> item) {
        item.render();
    }

    protected Iterator<Component> renderIterator() {
        final int size = this.size();
        return new ReadOnlyIterator<Component>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < size;
            }

            @Override
            public Component next() {
                String id = Integer.toString(ListView.this.firstIndex + this.index);
                ++this.index;
                return ListView.this.get(id);
            }
        };
    }

    public final IModel<? extends List<T>> getModel() {
        return this.getDefaultModel();
    }

    public final void setModel(IModel<? extends List<T>> model) {
        this.setDefaultModel((IModel)model);
    }

    public final List<T> getModelObject() {
        return (List)this.getDefaultModelObject();
    }

    public final void setModelObject(List<T> object) {
        this.setDefaultModelObject(object);
    }

    @Override
    public IMarkupFragment getMarkup(Component child) {
        return this.getMarkup();
    }
}

