/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.internal;

import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.IMarkupFragment;
import org.apache.wicket.markup.Markup;
import org.apache.wicket.markup.html.internal.Enclosure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InlineEnclosure
extends Enclosure {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(InlineEnclosure.class);
    private String enclosureMarkupAsString = null;

    public InlineEnclosure(String id, String childId) {
        super(id, childId);
        this.setOutputMarkupPlaceholderTag(true);
        this.setMarkupId(this.getId());
    }

    @Override
    protected void onComponentTag(ComponentTag tag) {
        tag.remove("wicket:enclosure");
        super.onComponentTag(tag);
    }

    public boolean updateVisibility() {
        boolean visible = this.getChild().isVisible();
        this.setVisible(visible);
        return visible;
    }

    @Override
    public IMarkupFragment getMarkup() {
        IMarkupFragment enclosureMarkup = null;
        if (this.enclosureMarkupAsString == null) {
            IMarkupFragment markup = super.getMarkup();
            if (markup != null && markup != Markup.NO_MARKUP) {
                enclosureMarkup = markup;
                this.enclosureMarkupAsString = markup.toString(true);
            }
        } else {
            enclosureMarkup = Markup.of(this.enclosureMarkupAsString);
        }
        return enclosureMarkup;
    }
}

