/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head.internal;

import java.util.HashSet;
import java.util.Set;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.request.Response;
import org.apache.wicket.response.NullResponse;

public abstract class HeaderResponse
implements IHeaderResponse {
    private final Set<Object> rendered = new HashSet<Object>();
    private boolean closed;

    @Override
    public final void markRendered(Object object) {
        this.rendered.add(object);
    }

    @Override
    public void render(HeaderItem item) {
        if (!this.closed && !this.wasItemRendered(item)) {
            item.render(this.getResponse());
            this.markItemRendered(item);
        }
    }

    protected boolean wasItemRendered(HeaderItem item) {
        for (Object curToken : item.getRenderTokens()) {
            if (!this.wasRendered(curToken)) continue;
            return true;
        }
        return false;
    }

    protected void markItemRendered(HeaderItem item) {
        for (Object curToken : item.getRenderTokens()) {
            this.markRendered(curToken);
        }
    }

    @Override
    public final boolean wasRendered(Object object) {
        return this.rendered.contains(object);
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public final Response getResponse() {
        return this.closed ? NullResponse.getInstance() : this.getRealResponse();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    protected abstract Response getRealResponse();
}

