/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head.filter;

import java.util.Arrays;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.filter.CssAndPageAcceptingHeaderResponseFilter;
import org.apache.wicket.markup.head.filter.FilteringHeaderResponse;
import org.apache.wicket.markup.head.filter.OppositeHeaderResponseFilter;

public final class JavaScriptFilteredIntoFooterHeaderResponse
extends FilteringHeaderResponse {
    public static final String HEADER_FILTER_NAME = "headerBucket";

    public JavaScriptFilteredIntoFooterHeaderResponse(IHeaderResponse response, String footerBucketName) {
        super(response, HEADER_FILTER_NAME, null);
        this.setFilters(this.createFilters(footerBucketName));
    }

    protected Iterable<? extends FilteringHeaderResponse.IHeaderResponseFilter> createFilters(String footerBucketName) {
        FilteringHeaderResponse.IHeaderResponseFilter header = this.createHeaderFilter(HEADER_FILTER_NAME);
        FilteringHeaderResponse.IHeaderResponseFilter footer = this.createFooterFilter(footerBucketName, header);
        return Arrays.asList(header, footer);
    }

    protected FilteringHeaderResponse.IHeaderResponseFilter createFooterFilter(String footerBucketName, FilteringHeaderResponse.IHeaderResponseFilter header) {
        return new OppositeHeaderResponseFilter(footerBucketName, header);
    }

    protected FilteringHeaderResponse.IHeaderResponseFilter createHeaderFilter(String headerFilterName) {
        return new CssAndPageAcceptingHeaderResponseFilter(HEADER_FILTER_NAME);
    }
}

