/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head.filter;

import java.util.ArrayList;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.request.Response;

public class FilteredHeaderItem
extends HeaderItem {
    private HeaderItem wrapped;
    private String filterName;

    public FilteredHeaderItem(HeaderItem wrapped, String filterName) {
        this.wrapped = wrapped;
        this.filterName = filterName;
    }

    public HeaderItem getWrapped() {
        return this.wrapped;
    }

    public String getFilterName() {
        return this.filterName;
    }

    @Override
    public Iterable<?> getRenderTokens() {
        return this.getWrapped().getRenderTokens();
    }

    @Override
    public void render(Response response) {
        this.getWrapped().render(response);
    }

    @Override
    public Iterable<? extends HeaderItem> getDependencies() {
        ArrayList<FilteredHeaderItem> ret = new ArrayList<FilteredHeaderItem>();
        for (HeaderItem headerItem : this.getWrapped().getDependencies()) {
            ret.add(new FilteredHeaderItem(headerItem, this.getFilterName()));
        }
        return ret;
    }

    @Override
    public Iterable<? extends HeaderItem> getProvidedResources() {
        return this.getWrapped().getProvidedResources();
    }

    public int hashCode() {
        return this.getWrapped().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof FilteredHeaderItem) {
            return ((FilteredHeaderItem)obj).getWrapped().equals(this.getWrapped());
        }
        return false;
    }

    public String toString() {
        return "FilteredHeaderItem(" + this.getWrapped() + ", " + this.getFilterName() + ")";
    }
}

