/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import java.util.Collections;
import org.apache.wicket.Application;
import org.apache.wicket.core.util.string.JavaScriptUtils;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.settings.IJavaScriptLibrarySettings;
import org.apache.wicket.util.lang.Args;

public class OnDomReadyHeaderItem
extends HeaderItem {
    private final CharSequence javaScript;

    public static OnDomReadyHeaderItem forScript(CharSequence javaScript) {
        return new OnDomReadyHeaderItem(javaScript);
    }

    public OnDomReadyHeaderItem(CharSequence javaScript) {
        this.javaScript = Args.notEmpty(javaScript, "javaScript");
    }

    public CharSequence getJavaScript() {
        return this.javaScript;
    }

    @Override
    public void render(Response response) {
        JavaScriptUtils.writeJavaScript(response, "Wicket.Event.add(window, \"domready\", function(event) { " + this.getJavaScript() + ";});");
    }

    @Override
    public Iterable<?> getRenderTokens() {
        return Collections.singletonList("javascript-domready-" + this.getJavaScript());
    }

    public String toString() {
        return "OnDomReadyHeaderItem(" + this.getJavaScript() + ")";
    }

    public int hashCode() {
        return this.getJavaScript().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof OnDomReadyHeaderItem) {
            return ((OnDomReadyHeaderItem)obj).getJavaScript().equals(this.getJavaScript());
        }
        return false;
    }

    @Override
    public Iterable<? extends HeaderItem> getDependencies() {
        IJavaScriptLibrarySettings ajaxSettings = Application.get().getJavaScriptLibrarySettings();
        ResourceReference wicketEventReference = ajaxSettings.getWicketEventReference();
        return Collections.singletonList(JavaScriptHeaderItem.forReference(wicketEventReference));
    }
}

