/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.head;

import java.util.Arrays;
import java.util.Collections;
import org.apache.wicket.core.util.string.UrlUtils;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.string.Strings;

public class JavaScriptUrlReferenceHeaderItem
extends JavaScriptHeaderItem {
    private final String url;
    private final String id;
    private final boolean defer;
    private final String charset;

    public JavaScriptUrlReferenceHeaderItem(String url, String id, boolean defer, String charset, String condition) {
        super(condition);
        this.url = url;
        this.id = id;
        this.defer = defer;
        this.charset = charset;
    }

    public String getUrl() {
        return this.url;
    }

    public String getId() {
        return this.id;
    }

    public boolean isDefer() {
        return this.defer;
    }

    public String getCharset() {
        return this.charset;
    }

    @Override
    public void render(Response response) {
        this.internalRenderJavaScriptReference(response, UrlUtils.rewriteToContextRelative(this.getUrl(), RequestCycle.get()), this.getId(), this.isDefer(), this.getCharset(), this.getCondition());
    }

    @Override
    public Iterable<?> getRenderTokens() {
        String url = UrlUtils.rewriteToContextRelative(this.getUrl(), RequestCycle.get());
        if (Strings.isEmpty(this.getId())) {
            return Collections.singletonList("javascript-" + url);
        }
        return Arrays.asList("javascript-" + this.getId(), "javascript-" + url);
    }

    public String toString() {
        return "JavaScriptUrlReferenceHeaderItem(" + this.getUrl() + ")";
    }

    public int hashCode() {
        return this.getUrl().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof JavaScriptUrlReferenceHeaderItem) {
            return ((JavaScriptUrlReferenceHeaderItem)obj).getUrl().equals(this.getUrl());
        }
        return false;
    }
}

